/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;

public class RequestHeaderAttribute
implements ExchangeAttribute {
    private final HttpString requestHeader;

    public RequestHeaderAttribute(HttpString requestHeader) {
        this.requestHeader = requestHeader;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getRequestHeaders().getFirst(this.requestHeader);
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.getRequestHeaders().put(this.requestHeader, newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request header";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{i,") && token.endsWith("}")) {
                HttpString headerName = HttpString.tryFromString(token.substring(4, token.length() - 1));
                return new RequestHeaderAttribute(headerName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

