/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsBackpressureStrategy;
import org.apache.camel.component.reactive.streams.ReactiveStreamsDiscardedException;
import org.apache.camel.component.reactive.streams.engine.CamelPublisher;
import org.apache.camel.component.reactive.streams.engine.StreamPayload;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSubscription
implements Subscription {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSubscription.class);
    private ExecutorService workerPool;
    private String name;
    private CamelPublisher publisher;
    private ReactiveStreamsBackpressureStrategy backpressureStrategy;
    private Subscriber<? super StreamPayload<Exchange>> subscriber;
    private Lock mutex = new ReentrantLock(true);
    private LinkedList<StreamPayload<Exchange>> buffer = new LinkedList();
    private long requested;
    private boolean terminating;
    private boolean terminated;
    private boolean sending;

    public CamelSubscription(ExecutorService workerPool, CamelPublisher publisher, String name, ReactiveStreamsBackpressureStrategy backpressureStrategy, Subscriber<? super StreamPayload<Exchange>> subscriber) {
        this.workerPool = workerPool;
        this.publisher = publisher;
        this.name = name;
        this.backpressureStrategy = backpressureStrategy;
        this.subscriber = subscriber;
    }

    public void request(long l) {
        LOG.debug("Requested {} events from subscriber", (Object)l);
        if (l <= 0L) {
            this.mutex.lock();
            this.terminated = true;
            this.mutex.unlock();
            this.publisher.unsubscribe(this);
            this.subscriber.onError((Throwable)new IllegalArgumentException("3.9"));
        } else {
            this.mutex.lock();
            this.requested += l;
            this.mutex.unlock();
            this.checkAndFlush();
        }
    }

    protected void checkAndFlush() {
        boolean shouldFlush;
        this.mutex.lock();
        boolean bl = shouldFlush = !this.terminated && !this.sending && this.requested > 0L && this.buffer.size() > 0;
        if (shouldFlush) {
            this.sending = true;
        }
        this.mutex.unlock();
        if (shouldFlush) {
            this.workerPool.execute(() -> {
                this.flush();
                this.mutex.lock();
                this.sending = false;
                this.mutex.unlock();
                this.checkAndFlush();
            });
        } else {
            boolean shouldComplete;
            this.mutex.lock();
            boolean bl2 = shouldComplete = this.terminating && !this.terminated;
            if (shouldComplete) {
                this.terminated = true;
            }
            this.mutex.unlock();
            if (shouldComplete) {
                this.publisher.unsubscribe(this);
                this.subscriber.onComplete();
                this.discardBuffer(this.buffer);
            }
        }
    }

    protected void flush() {
        LinkedList<StreamPayload<Exchange>> sendingQueue = null;
        try {
            this.mutex.lock();
            if (this.terminated) {
                return;
            }
            int amount = (int)Math.min(this.requested, (long)this.buffer.size());
            if (amount > 0) {
                this.requested -= (long)amount;
                sendingQueue = new LinkedList<StreamPayload<Exchange>>();
                while (amount > 0) {
                    sendingQueue.add(this.buffer.removeFirst());
                    --amount;
                }
            }
        }
        finally {
            this.mutex.unlock();
        }
        if (sendingQueue != null) {
            LOG.debug("Sending {} events to the subscriber", (Object)sendingQueue.size());
            for (StreamPayload streamPayload : sendingQueue) {
                this.subscriber.onNext((Object)streamPayload);
                this.mutex.lock();
                boolean shouldStop = this.terminated;
                this.mutex.unlock();
                if (!shouldStop) continue;
                break;
            }
        }
    }

    public void signalCompletion() throws Exception {
        this.mutex.lock();
        this.terminating = true;
        this.mutex.unlock();
        this.checkAndFlush();
    }

    public void cancel() {
        this.publisher.unsubscribe(this);
        this.mutex.lock();
        this.terminated = true;
        LinkedList<StreamPayload<Exchange>> bufferCopy = new LinkedList<StreamPayload<Exchange>>(this.buffer);
        this.buffer.clear();
        this.mutex.unlock();
        this.discardBuffer(bufferCopy);
    }

    protected void discardBuffer(List<StreamPayload<Exchange>> remaining) {
        for (StreamPayload<Exchange> data : remaining) {
            data.getCallback().processed(data.getItem(), new IllegalStateException("Cannot process the exchange " + data.getItem() + ": subscription cancelled"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(StreamPayload<Exchange> message) {
        Map<StreamPayload<Exchange>, String> discardedMessages = null;
        try {
            this.mutex.lock();
            if (!this.terminating && !this.terminated) {
                Collection<StreamPayload<Exchange>> discarded = this.backpressureStrategy.update(this.buffer, message);
                if (discarded.iterator().hasNext()) {
                    discardedMessages = new HashMap<StreamPayload<Exchange>, String>();
                    for (StreamPayload<Exchange> ex : discarded) {
                        discardedMessages.put(ex, "Exchange " + ex.getItem() + " discarded by backpressure strategy " + (Object)((Object)this.backpressureStrategy));
                    }
                }
            } else {
                discardedMessages = Collections.singletonMap(message, "Exchange " + message.getItem() + " discarded: subscription closed");
            }
        }
        finally {
            this.mutex.unlock();
        }
        if (discardedMessages != null) {
            for (Map.Entry<StreamPayload<Exchange>, String> discarded : discardedMessages.entrySet()) {
                StreamPayload<Exchange> m = discarded.getKey();
                Exchange exchange = m.getItem();
                ReactiveStreamsDiscardedException e = new ReactiveStreamsDiscardedException("Discarded by backpressure strategy", exchange, this.name);
                m.getCallback().processed(exchange, (Throwable)((Object)e));
            }
        }
        this.checkAndFlush();
    }

    public void setBackpressureStrategy(ReactiveStreamsBackpressureStrategy backpressureStrategy) {
        this.mutex.lock();
        this.backpressureStrategy = backpressureStrategy;
        this.mutex.unlock();
    }

    public long getBufferSize() {
        return this.buffer.size();
    }

    public ReactiveStreamsBackpressureStrategy getBackpressureStrategy() {
        return this.backpressureStrategy;
    }
}

