/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.engine;

import java.util.Objects;
import org.apache.camel.component.reactive.streams.engine.StreamPayload;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnwrappingPublisher<R>
implements Publisher<R> {
    private static final Logger LOG = LoggerFactory.getLogger(UnwrappingPublisher.class);
    private Publisher<StreamPayload<R>> delegate;

    public UnwrappingPublisher(Publisher<StreamPayload<R>> delegate) {
        Objects.requireNonNull(delegate, "delegate publisher cannot be null");
        this.delegate = delegate;
    }

    public void subscribe(final Subscriber<? super R> subscriber) {
        this.delegate.subscribe(new Subscriber<StreamPayload<R>>(){
            private Subscription subscription;

            public void onSubscribe(Subscription newSubscription) {
                if (newSubscription == null) {
                    throw new NullPointerException("subscription is null");
                }
                if (newSubscription == this.subscription) {
                    throw new IllegalArgumentException("already subscribed to the subscription: " + newSubscription);
                }
                if (this.subscription != null) {
                    newSubscription.cancel();
                } else {
                    this.subscription = newSubscription;
                    subscriber.onSubscribe(newSubscription);
                }
            }

            public void onNext(StreamPayload<R> payload) {
                Throwable error = null;
                try {
                    subscriber.onNext(payload.getItem());
                }
                catch (Throwable t) {
                    error = t;
                }
                if (payload.getCallback() != null) {
                    payload.getCallback().processed(payload.getItem(), error);
                }
            }

            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }
}

