/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.deployment;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupHandler;
import javax.servlet.ServletContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.undertow.OIDCUndertowHttpFacade;
import org.wildfly.swarm.keycloak.deployment.KeycloakSecurityContextAssociation;
import org.wildfly.swarm.keycloak.deployment.KeycloakThreadSetupHandler;

public class SecurityContextServletExtension
implements ServletExtension {
    public void handleDeployment(DeploymentInfo info, ServletContext context) {
        info.addThreadSetupAction((ThreadSetupHandler)new KeycloakThreadSetupHandler());
        info.addInnerHandlerChainWrapper(next -> exchange -> {
            KeycloakSecurityContext c = (KeycloakSecurityContext)exchange.getAttachment(OIDCUndertowHttpFacade.KEYCLOAK_SECURITY_CONTEXT_KEY);
            if (c != null) {
                KeycloakSecurityContextAssociation.associate(c);
            }
            try {
                next.handleRequest(exchange);
            }
            finally {
                KeycloakSecurityContextAssociation.disassociate();
            }
        });
    }
}

