/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import com.github.kristofa.brave.IdConversion;
import com.github.kristofa.brave.SpanId;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;

public final class ZipkinHelper {
    private ZipkinHelper() {
    }

    public static SpanId createSpanId(String traceId, String spanId, String parentSpanId) {
        if (parentSpanId != null) {
            return SpanId.builder().traceId(IdConversion.convertToLong((String)traceId)).spanId(IdConversion.convertToLong((String)spanId)).parentId(Long.valueOf(IdConversion.convertToLong((String)parentSpanId))).build();
        }
        return SpanId.builder().traceId(IdConversion.convertToLong((String)traceId)).spanId(IdConversion.convertToLong((String)spanId)).build();
    }

    public static StreamCache prepareBodyForLogging(Exchange exchange, boolean streams) {
        if (!streams) {
            return null;
        }
        Message message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        Object body = message.getBody();
        if (body == null) {
            return null;
        }
        if (body instanceof StreamCache) {
            StreamCache sc = (StreamCache)body;
            sc.reset();
            return sc;
        }
        StreamCache sc = exchange.getContext().getStreamCachingStrategy().cache(exchange);
        if (sc != null) {
            message.setBody((Object)sc);
        }
        return sc;
    }
}

