/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy;

import com.netflix.ribbon.RequestTemplate;
import com.netflix.ribbon.ResourceGroup;
import com.netflix.ribbon.RibbonRequest;
import com.netflix.ribbon.http.HttpRequestBuilder;
import com.netflix.ribbon.http.HttpRequestTemplate;
import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.proxy.MethodTemplate;
import com.netflix.ribbon.proxy.Utils;
import com.netflix.ribbon.proxy.processor.AnnotationProcessor;
import com.netflix.ribbon.proxy.processor.AnnotationProcessorsProvider;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.reactivex.netty.channel.ContentTransformer;
import io.reactivex.netty.channel.StringTransformer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;

class MethodTemplateExecutor {
    private static final ContentTransformer<ByteBuf> BYTE_BUF_TRANSFORMER = new ContentTransformer<ByteBuf>(){

        public ByteBuf call(ByteBuf toTransform, ByteBufAllocator byteBufAllocator) {
            return toTransform;
        }
    };
    private static final ContentTransformer<byte[]> BYTE_ARRAY_TRANSFORMER = new ContentTransformer<byte[]>(){

        public ByteBuf call(byte[] toTransform, ByteBufAllocator byteBufAllocator) {
            ByteBuf byteBuf = byteBufAllocator.buffer(toTransform.length);
            byteBuf.writeBytes(toTransform);
            return byteBuf;
        }
    };
    private static final StringTransformer STRING_TRANSFORMER = new StringTransformer();
    private final HttpResourceGroup httpResourceGroup;
    private final MethodTemplate methodTemplate;
    private final HttpRequestTemplate.Builder<?> httpRequestTemplateBuilder;

    MethodTemplateExecutor(HttpResourceGroup httpResourceGroup, MethodTemplate methodTemplate, AnnotationProcessorsProvider annotations) {
        this.httpResourceGroup = httpResourceGroup;
        this.methodTemplate = methodTemplate;
        this.httpRequestTemplateBuilder = this.createHttpRequestTemplateBuilder();
        for (AnnotationProcessor processor : annotations.getProcessors()) {
            processor.process(methodTemplate.getTemplateName(), this.httpRequestTemplateBuilder, methodTemplate.getMethod());
        }
    }

    public <O> RibbonRequest<O> executeFromTemplate(Object[] args) {
        RequestTemplate.RequestBuilder requestBuilder = ((HttpRequestTemplate)this.httpRequestTemplateBuilder.build()).requestBuilder();
        this.withParameters((HttpRequestBuilder<?>)requestBuilder, args);
        this.withContent((HttpRequestBuilder<?>)requestBuilder, args);
        return ((HttpRequestBuilder)requestBuilder).build();
    }

    private HttpRequestTemplate.Builder<?> createHttpRequestTemplateBuilder() {
        HttpRequestTemplate.Builder<?> httpRequestTemplateBuilder = this.createBaseHttpRequestTemplate(this.httpResourceGroup);
        return httpRequestTemplateBuilder;
    }

    private HttpRequestTemplate.Builder<?> createBaseHttpRequestTemplate(HttpResourceGroup httpResourceGroup) {
        ResourceGroup.TemplateBuilder httpRequestTemplate = ByteBuf.class.isAssignableFrom(this.methodTemplate.getResultType()) ? httpResourceGroup.newTemplateBuilder(this.methodTemplate.getTemplateName()) : httpResourceGroup.newTemplateBuilder(this.methodTemplate.getTemplateName(), this.methodTemplate.getResultType());
        return httpRequestTemplate;
    }

    private void withParameters(HttpRequestBuilder<?> requestBuilder, Object[] args) {
        int length = this.methodTemplate.getParamSize();
        for (int i = 0; i < length; ++i) {
            String name = this.methodTemplate.getParamName(i);
            Object value = args[this.methodTemplate.getParamPosition(i)];
            requestBuilder.withRequestProperty(name, value);
        }
    }

    private void withContent(HttpRequestBuilder<?> requestBuilder, Object[] args) {
        if (this.methodTemplate.getContentArgPosition() < 0) {
            return;
        }
        Object contentValue = args[this.methodTemplate.getContentArgPosition()];
        if (contentValue instanceof Observable) {
            if (ByteBuf.class.isAssignableFrom(this.methodTemplate.getGenericContentType())) {
                requestBuilder.withContent((Observable<ByteBuf>)((Observable)contentValue));
            } else {
                ContentTransformer<?> contentTransformer = Utils.newInstance(this.methodTemplate.getContentTransformerClass());
                requestBuilder.withRawContentSource((Observable)contentValue, contentTransformer);
            }
        } else if (contentValue instanceof ByteBuf) {
            requestBuilder.withRawContentSource(Observable.just((Object)((ByteBuf)contentValue)), BYTE_BUF_TRANSFORMER);
        } else if (contentValue instanceof byte[]) {
            requestBuilder.withRawContentSource(Observable.just((Object)((byte[])contentValue)), BYTE_ARRAY_TRANSFORMER);
        } else if (contentValue instanceof String) {
            requestBuilder.withRawContentSource(Observable.just((Object)((String)contentValue)), STRING_TRANSFORMER);
        } else {
            ContentTransformer<?> contentTransformer = Utils.newInstance(this.methodTemplate.getContentTransformerClass());
            requestBuilder.withRawContentSource(Observable.just((Object)contentValue), contentTransformer);
        }
    }

    public static Map<Method, MethodTemplateExecutor> from(HttpResourceGroup httpResourceGroup, Class<?> clientInterface, AnnotationProcessorsProvider annotations) {
        MethodTemplate[] methodTemplates = MethodTemplate.from(clientInterface);
        HashMap<Method, MethodTemplateExecutor> tgm = new HashMap<Method, MethodTemplateExecutor>();
        for (MethodTemplate mt : methodTemplates) {
            tgm.put(mt.getMethod(), new MethodTemplateExecutor(httpResourceGroup, mt, annotations));
        }
        return tgm;
    }
}

