/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;

class ManagementHttpRequestHandler
implements HttpHandler {
    private final HttpHandler next;
    private final ManagementHttpRequestProcessor service;
    private final ExchangeCompletionListener listener = new ExchangeCompletionListener(){

        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            ManagementHttpRequestHandler.this.service.endRequest();
            nextListener.proceed();
        }
    };

    public ManagementHttpRequestHandler(ManagementHttpRequestProcessor service, HttpHandler next) {
        this.service = service;
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean proceed = this.service.beginRequest();
        try {
            if (proceed) {
                this.next.handleRequest(exchange);
            } else {
                exchange.setResponseCode(503);
                exchange.endExchange();
            }
        }
        finally {
            if (proceed && (exchange.isComplete() || !exchange.isDispatched())) {
                this.service.endRequest();
            } else if (proceed) {
                exchange.addExchangeCompleteListener(this.listener);
            }
        }
    }
}

