/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.TwitterConsumer;
import org.apache.camel.component.twitter.consumer.directmessage.DirectMessageConsumer;
import org.apache.camel.component.twitter.consumer.search.SearchConsumer;
import org.apache.camel.component.twitter.consumer.streaming.FilterStreamingConsumer;
import org.apache.camel.component.twitter.consumer.streaming.SampleStreamingConsumer;
import org.apache.camel.component.twitter.consumer.streaming.UserStreamingConsumer;
import org.apache.camel.component.twitter.consumer.timeline.HomeConsumer;
import org.apache.camel.component.twitter.consumer.timeline.MentionsConsumer;
import org.apache.camel.component.twitter.consumer.timeline.RetweetsConsumer;
import org.apache.camel.component.twitter.consumer.timeline.UserConsumer;
import org.apache.camel.component.twitter.data.ConsumerType;
import org.apache.camel.component.twitter.data.StreamingType;
import org.apache.camel.component.twitter.data.TimelineType;
import org.apache.camel.component.twitter.producer.DirectMessageProducer;
import org.apache.camel.component.twitter.producer.SearchProducer;
import org.apache.camel.component.twitter.producer.TwitterProducer;
import org.apache.camel.component.twitter.producer.UserProducer;
import twitter4j.User;

public final class TwitterHelper {
    private static final Pattern TWITTER_SCHEMA_PATTERN = Pattern.compile("twitter:(//)*");
    private static final Pattern TWITTER_OPTIONS_PATTERN = Pattern.compile("\\?.*");

    private TwitterHelper() {
    }

    public static void setUserHeader(Exchange exchange, User user) {
        TwitterHelper.setUserHeader(exchange.getIn(), user);
    }

    public static void setUserHeader(Message message, User user) {
        message.setHeader("CamelTwitterUser", (Object)user);
    }

    public static void setUserHeader(Exchange exchange, int index, User user, String role) {
        TwitterHelper.setUserHeader(exchange.getIn(), index, user, role);
    }

    public static void setUserHeader(Message message, int index, User user, String role) {
        message.setHeader("CamelTwitterUser" + index, (Object)user);
        message.setHeader("CamelTwitterUserRole" + index, (Object)role);
    }

    public static TwitterConsumer createConsumer(TwitterEndpoint te, String uri) throws IllegalArgumentException {
        String[] uriSplit = TwitterHelper.splitUri(uri);
        if (uriSplit.length > 0) {
            switch (ConsumerType.fromUri(uriSplit[0])) {
                case DIRECTMESSAGE: {
                    return new DirectMessageConsumer(te);
                }
                case SEARCH: {
                    boolean hasNoKeywords;
                    boolean bl = hasNoKeywords = te.getProperties().getKeywords() == null || te.getProperties().getKeywords().trim().isEmpty();
                    if (hasNoKeywords) {
                        throw new IllegalArgumentException("Type set to SEARCH but no keywords were provided.");
                    }
                    return new SearchConsumer(te);
                }
                case STREAMING: {
                    switch (StreamingType.fromUri(uriSplit[1])) {
                        case SAMPLE: {
                            return new SampleStreamingConsumer(te);
                        }
                        case FILTER: {
                            return new FilterStreamingConsumer(te);
                        }
                        case USER: {
                            return new UserStreamingConsumer(te);
                        }
                    }
                    break;
                }
                case TIMELINE: {
                    if (uriSplit.length <= 1) break;
                    switch (TimelineType.fromUri(uriSplit[1])) {
                        case HOME: {
                            return new HomeConsumer(te);
                        }
                        case MENTIONS: {
                            return new MentionsConsumer(te);
                        }
                        case RETWEETSOFME: {
                            return new RetweetsConsumer(te);
                        }
                        case USER: {
                            if (te.getProperties().getUser() == null || te.getProperties().getUser().trim().isEmpty()) {
                                throw new IllegalArgumentException("Fetch type set to USER TIMELINE but no user was set.");
                            }
                            return new UserConsumer(te);
                        }
                    }
                    break;
                }
            }
        }
        throw new IllegalArgumentException("Cannot create any consumer with uri " + uri + ". A consumer type was not provided (or an incorrect pairing was used).");
    }

    public static TwitterProducer createProducer(TwitterEndpoint te, String uri) throws IllegalArgumentException {
        String[] uriSplit = TwitterHelper.splitUri(uri);
        if (uriSplit.length > 0) {
            switch (ConsumerType.fromUri(uriSplit[0])) {
                case DIRECTMESSAGE: {
                    if (te.getProperties().getUser() == null || te.getProperties().getUser().trim().isEmpty()) {
                        throw new IllegalArgumentException("Producer type set to DIRECT MESSAGE but no recipient user was set.");
                    }
                    return new DirectMessageProducer(te);
                }
                case TIMELINE: {
                    if (uriSplit.length <= 1) break;
                    switch (TimelineType.fromUri(uriSplit[1])) {
                        case USER: {
                            return new UserProducer(te);
                        }
                    }
                    break;
                }
                case SEARCH: {
                    return new SearchProducer(te);
                }
            }
        }
        throw new IllegalArgumentException("Cannot create any producer with uri " + uri + ". A producer type was not provided (or an incorrect pairing was used).");
    }

    private static String[] splitUri(String uri) {
        uri = TWITTER_SCHEMA_PATTERN.matcher(uri).replaceAll("");
        uri = TWITTER_OPTIONS_PATTERN.matcher(uri).replaceAll("");
        return uri.split("/");
    }

    public static <T extends Enum<T>> T enumFromString(T[] values, String uri, T defaultValue) {
        for (int i = values.length - 1; i >= 0; --i) {
            if (!((Enum)values[i]).name().equalsIgnoreCase(uri)) continue;
            return values[i];
        }
        return defaultValue;
    }
}

