/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.producer;

import java.util.List;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.producer.TwitterProducer;
import org.apache.camel.util.ObjectHelper;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Twitter;

public class SearchProducer
extends TwitterProducer {
    private volatile long lastId;

    public SearchProducer(TwitterEndpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        Integer numberOfPages;
        Integer count;
        String lang;
        Long maxId;
        Long sinceId;
        long myLastId = this.lastId;
        String keywords = (String)exchange.getIn().getHeader("CamelTwitterKeywords", String.class);
        if (keywords == null) {
            keywords = this.endpoint.getProperties().getKeywords();
        }
        if (keywords == null) {
            throw new CamelExchangeException("No keywords to use for query", exchange);
        }
        Query query = new Query(keywords);
        if (this.endpoint.getProperties().isFilterOld() && myLastId != 0L) {
            query.setSinceId(myLastId);
        }
        if ((sinceId = (Long)exchange.getIn().getHeader("CamelTwitterSinceId", Long.class)) == null) {
            sinceId = this.endpoint.getProperties().getSinceId();
        }
        if (ObjectHelper.isNotEmpty((Object)sinceId)) {
            query.setSinceId(sinceId.longValue());
        }
        if (ObjectHelper.isNotEmpty((Object)(maxId = (Long)exchange.getIn().getHeader("CamelTwitterMaxId", Long.class)))) {
            query.setMaxId(maxId.longValue());
        }
        if ((lang = (String)exchange.getIn().getHeader("CamelTwitterSearchLanguage", String.class)) == null) {
            lang = this.endpoint.getProperties().getLang();
        }
        if (ObjectHelper.isNotEmpty((Object)lang)) {
            query.setLang(lang);
        }
        if ((count = (Integer)exchange.getIn().getHeader("CamelTwitterCount", Integer.class)) == null) {
            count = this.endpoint.getProperties().getCount();
        }
        if (ObjectHelper.isNotEmpty((Object)count)) {
            query.setCount(count.intValue());
        }
        if ((numberOfPages = (Integer)exchange.getIn().getHeader("CamelTwitterNumberOfPages", Integer.class)) == null) {
            numberOfPages = this.endpoint.getProperties().getNumberOfPages();
        }
        Twitter twitter = this.endpoint.getProperties().getTwitter();
        this.log.debug("Searching twitter with keywords: {}", (Object)keywords);
        QueryResult results = twitter.search(query);
        List list = results.getTweets();
        for (int i = 1; i < numberOfPages && results.hasNext(); ++i) {
            this.log.debug("Fetching page");
            results = twitter.search(results.nextQuery());
            list.addAll(results.getTweets());
        }
        if (this.endpoint.getProperties().isFilterOld()) {
            for (Status t : list) {
                long newId = t.getId();
                if (newId <= myLastId) continue;
                myLastId = newId;
            }
        }
        exchange.getIn().setBody((Object)list);
        if (myLastId > this.lastId) {
            this.lastId = myLastId;
        }
    }
}

