/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.util;

import java.text.ParseException;
import org.apache.camel.Converter;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.Trend;
import twitter4j.Trends;
import twitter4j.UserList;

@Converter
public final class TwitterConverter {
    private TwitterConverter() {
    }

    @Converter
    public static String toString(Status status) throws ParseException {
        return status.getCreatedAt() + " (" + status.getUser().getScreenName() + ") " + status.getText();
    }

    @Converter
    public static String toString(DirectMessage dm) throws ParseException {
        return dm.getCreatedAt() + " (" + dm.getSenderScreenName() + ") " + dm.getText();
    }

    @Converter
    public static String toString(Trend trend) throws ParseException {
        return trend.getName();
    }

    @Converter
    public static String toString(Trends trends) throws ParseException {
        StringBuilder s = new StringBuilder();
        s.append("(" + trends.getTrendAt().toString() + ") ");
        boolean first = true;
        for (Trend trend : trends.getTrends()) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append(TwitterConverter.toString(trend));
        }
        return s.toString();
    }

    @Converter
    public static String toString(UserList userList) throws ParseException {
        return userList.getCreatedAt() + " (" + userList.getUser().getScreenName() + ") " + userList.getFullName() + ',' + userList.getURI() + ',';
    }
}

