/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.CollectionUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BusEntityResolver
extends DelegatingEntityResolver {
    private static final Logger LOG = LogUtils.getL7dLogger(BusEntityResolver.class);
    private EntityResolver dtdResolver;
    private EntityResolver schemaResolver;
    private Map<String, String> schemaMappings;
    private ClassLoader classLoader;

    public BusEntityResolver(ClassLoader loader, EntityResolver dr, EntityResolver sr) {
        super(dr, sr);
        this.classLoader = loader;
        this.dtdResolver = dr;
        this.schemaResolver = sr;
        try {
            Properties mappings = PropertiesLoaderUtils.loadAllProperties((String)"META-INF/spring.schemas", (ClassLoader)this.classLoader);
            this.schemaMappings = new ConcurrentHashMap<String, String>(mappings.size());
            CollectionUtils.mergePropertiesIntoMap((Properties)mappings, this.schemaMappings);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        ClassPathResource resource;
        String resourceLocation;
        InputSource source = super.resolveEntity(publicId, systemId);
        if (null == source && null != systemId) {
            LOG.log(Level.FINE, "Attempting to resolve systemId {0}", systemId);
            source = this.schemaResolver.resolveEntity(publicId, systemId);
            if (null == source) {
                source = this.dtdResolver.resolveEntity(publicId, systemId);
            }
        }
        if ((resourceLocation = this.schemaMappings.get(systemId)) != null && publicId == null && (resource = new ClassPathResource(resourceLocation, this.classLoader)) != null && resource.exists()) {
            source.setPublicId(systemId);
            source.setSystemId(resource.getURL().toString());
        }
        return source;
    }
}

