/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContexSchedulerAction;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.internal.schedulers.ScheduledAction;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public class HystrixContextScheduler
extends Scheduler {
    private final HystrixConcurrencyStrategy concurrencyStrategy;
    private final Scheduler actualScheduler;
    private final HystrixThreadPool threadPool;

    public HystrixContextScheduler(Scheduler scheduler) {
        this.actualScheduler = scheduler;
        this.concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        this.threadPool = null;
    }

    public HystrixContextScheduler(HystrixConcurrencyStrategy concurrencyStrategy, Scheduler scheduler) {
        this.actualScheduler = scheduler;
        this.concurrencyStrategy = concurrencyStrategy;
        this.threadPool = null;
    }

    public HystrixContextScheduler(HystrixConcurrencyStrategy concurrencyStrategy, HystrixThreadPool threadPool) {
        this(concurrencyStrategy, threadPool, new Func0<Boolean>(){

            public Boolean call() {
                return true;
            }
        });
    }

    public HystrixContextScheduler(HystrixConcurrencyStrategy concurrencyStrategy, HystrixThreadPool threadPool, Func0<Boolean> shouldInterruptThread) {
        this.concurrencyStrategy = concurrencyStrategy;
        this.threadPool = threadPool;
        this.actualScheduler = new ThreadPoolScheduler(threadPool, shouldInterruptThread);
    }

    public Scheduler.Worker createWorker() {
        return new HystrixContextSchedulerWorker(this.actualScheduler.createWorker());
    }

    private static class FutureCompleterWithConfigurableInterrupt
    implements Subscription {
        private final Future<?> f;
        private final Func0<Boolean> shouldInterruptThread;

        private FutureCompleterWithConfigurableInterrupt(Future<?> f, Func0<Boolean> shouldInterruptThread) {
            this.f = f;
            this.shouldInterruptThread = shouldInterruptThread;
        }

        public void unsubscribe() {
            if (((Boolean)this.shouldInterruptThread.call()).booleanValue()) {
                this.f.cancel(true);
            } else {
                this.f.cancel(false);
            }
        }

        public boolean isUnsubscribed() {
            return this.f.isCancelled();
        }
    }

    private static class ThreadPoolWorker
    extends Scheduler.Worker {
        private final HystrixThreadPool threadPool;
        private final CompositeSubscription subscription = new CompositeSubscription();
        private final Func0<Boolean> shouldInterruptThread;

        public ThreadPoolWorker(HystrixThreadPool threadPool, Func0<Boolean> shouldInterruptThread) {
            this.threadPool = threadPool;
            this.shouldInterruptThread = shouldInterruptThread;
        }

        public void unsubscribe() {
            this.subscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.subscription.isUnsubscribed();
        }

        public Subscription schedule(Action0 action) {
            if (this.subscription.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            ScheduledAction sa = new ScheduledAction(action);
            this.subscription.add((Subscription)sa);
            sa.addParent(this.subscription);
            Future<?> f = this.threadPool.getExecutor().submit((Runnable)sa);
            sa.add((Subscription)new FutureCompleterWithConfigurableInterrupt(f, this.shouldInterruptThread));
            return sa;
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            throw new IllegalStateException("Hystrix does not support delayed scheduling");
        }
    }

    private static class ThreadPoolScheduler
    extends Scheduler {
        private final HystrixThreadPool threadPool;
        private final Func0<Boolean> shouldInterruptThread;

        public ThreadPoolScheduler(HystrixThreadPool threadPool, Func0<Boolean> shouldInterruptThread) {
            this.threadPool = threadPool;
            this.shouldInterruptThread = shouldInterruptThread;
        }

        public Scheduler.Worker createWorker() {
            return new ThreadPoolWorker(this.threadPool, this.shouldInterruptThread);
        }
    }

    private class HystrixContextSchedulerWorker
    extends Scheduler.Worker {
        private final Scheduler.Worker worker;

        private HystrixContextSchedulerWorker(Scheduler.Worker actualWorker) {
            this.worker = actualWorker;
        }

        public void unsubscribe() {
            this.worker.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.worker.isUnsubscribed();
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            if (HystrixContextScheduler.this.threadPool != null && !HystrixContextScheduler.this.threadPool.isQueueSpaceAvailable()) {
                throw new RejectedExecutionException("Rejected command because thread-pool queueSize is at rejection threshold.");
            }
            return this.worker.schedule((Action0)new HystrixContexSchedulerAction(HystrixContextScheduler.this.concurrencyStrategy, action), delayTime, unit);
        }

        public Subscription schedule(Action0 action) {
            if (HystrixContextScheduler.this.threadPool != null && !HystrixContextScheduler.this.threadPool.isQueueSpaceAvailable()) {
                throw new RejectedExecutionException("Rejected command because thread-pool queueSize is at rejection threshold.");
            }
            return this.worker.schedule((Action0)new HystrixContexSchedulerAction(HystrixContextScheduler.this.concurrencyStrategy, action));
        }
    }
}

