/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.component.crypto.DigitalSignatureEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

public class DigitalSignatureComponent
extends UriEndpointComponent {
    @Metadata(label="advanced")
    private DigitalSignatureConfiguration configuration;

    public DigitalSignatureComponent() {
        super(DigitalSignatureEndpoint.class);
    }

    public DigitalSignatureComponent(CamelContext context) {
        super(context, DigitalSignatureEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext");
        DigitalSignatureConfiguration config = this.getConfiguration().copy();
        this.setProperties(config, parameters);
        config.setCamelContext(this.getCamelContext());
        try {
            config.setCryptoOperation(new URI(remaining).getScheme());
        }
        catch (Exception e) {
            throw new MalformedURLException(String.format("An invalid crypto uri was provided '%s'. Check the uri matches the format crypto:sign or crypto:verify", uri));
        }
        return new DigitalSignatureEndpoint(uri, this, config);
    }

    public DigitalSignatureConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new DigitalSignatureConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(DigitalSignatureConfiguration configuration) {
        this.configuration = configuration;
    }
}

