/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import org.apache.camel.component.salesforce.AuthenticationType;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.KeyStoreParameters;

public class SalesforceLoginConfig {
    public static final String DEFAULT_LOGIN_URL = "https://login.salesforce.com";
    private AuthenticationType type;
    private String loginUrl;
    private String clientId;
    private String clientSecret;
    private String refreshToken;
    private String userName;
    private String password;
    private boolean lazyLogin;
    private KeyStoreParameters keystore;

    public SalesforceLoginConfig() {
        this.loginUrl = DEFAULT_LOGIN_URL;
        this.lazyLogin = false;
    }

    private SalesforceLoginConfig(AuthenticationType type, String loginUrl, String clientId, String clientSecret, String refreshToken, String userName, String password, boolean lazyLogin, KeyStoreParameters keystore) {
        this.type = type;
        this.loginUrl = loginUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.refreshToken = refreshToken;
        this.userName = userName;
        this.password = password;
        this.lazyLogin = lazyLogin;
        this.keystore = keystore;
    }

    public SalesforceLoginConfig(String loginUrl, String clientId, String clientSecret, String userName, String password, boolean lazyLogin) {
        this(AuthenticationType.USERNAME_PASSWORD, loginUrl, clientId, clientSecret, null, userName, password, lazyLogin, null);
    }

    public SalesforceLoginConfig(String loginUrl, String clientId, String clientSecret, String refreshToken, boolean lazyLogin) {
        this(AuthenticationType.REFRESH_TOKEN, loginUrl, clientId, clientSecret, refreshToken, null, null, lazyLogin, null);
    }

    public SalesforceLoginConfig(String loginUrl, String clientId, String userName, KeyStoreParameters keystore, boolean lazyLogin) {
        this(AuthenticationType.JWT, loginUrl, clientId, null, null, userName, null, lazyLogin, keystore);
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setKeystore(KeyStoreParameters keystore) {
        this.keystore = keystore;
    }

    public KeyStoreParameters getKeystore() {
        return this.keystore;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public AuthenticationType getType() {
        boolean hasKeystore;
        if (this.type != null) {
            return this.type;
        }
        boolean hasPassword = ObjectHelper.isNotEmpty((Object)this.password);
        boolean hasRefreshToken = ObjectHelper.isNotEmpty((Object)this.refreshToken);
        boolean bl = hasKeystore = this.keystore != null && ObjectHelper.isNotEmpty((Object)this.keystore.getResource());
        if (hasPassword && !hasRefreshToken && !hasKeystore) {
            return AuthenticationType.USERNAME_PASSWORD;
        }
        if (!hasPassword && hasRefreshToken && !hasKeystore) {
            return AuthenticationType.REFRESH_TOKEN;
        }
        if (!hasPassword && hasRefreshToken && hasKeystore) {
            return AuthenticationType.JWT;
        }
        if (hasPassword && hasRefreshToken || hasPassword && hasKeystore || hasRefreshToken && hasKeystore) {
            throw new IllegalArgumentException("The provided authentication configuration can be used in multiple ways for instance both with username/password and refresh_token. Either remove some of the configuration options, so that authentication method can be auto-determined or explicitly set the authentication type.");
        }
        throw new IllegalArgumentException("You must specify parameters aligned with one of the supported authentication methods: for username and password authentication: userName, password, clientSecret; for refresh token authentication: refreshToken, clientSecret; for JWT: userName, keystore. And for every one of those loginUrl and clientId must be specified also.");
    }

    public void setType(AuthenticationType type) {
        this.type = type;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isLazyLogin() {
        return this.lazyLogin;
    }

    public void setLazyLogin(boolean lazyLogin) {
        this.lazyLogin = lazyLogin;
    }

    public void validate() {
        ObjectHelper.notNull((Object)this.loginUrl, (String)"loginUrl");
        ObjectHelper.notNull((Object)this.clientId, (String)"clientId");
        AuthenticationType type = this.getType();
        switch (type) {
            case USERNAME_PASSWORD: {
                ObjectHelper.notNull((Object)this.userName, (String)"userName (username/password authentication)");
                ObjectHelper.notNull((Object)this.password, (String)"password (username/password authentication)");
                ObjectHelper.notNull((Object)this.clientSecret, (String)"clientSecret (username/password authentication)");
                break;
            }
            case REFRESH_TOKEN: {
                ObjectHelper.notNull((Object)this.refreshToken, (String)"refreshToken (authentication with refresh token)");
                ObjectHelper.notNull((Object)this.clientSecret, (String)"clientSecret (authentication with refresh token)");
                break;
            }
            case JWT: {
                ObjectHelper.notNull((Object)this.userName, (String)"userName (JWT authentication)");
                ObjectHelper.notNull((Object)this.keystore, (String)"keystore (JWT authentication)");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown authentication type: " + (Object)((Object)type));
            }
        }
    }

    public String toString() {
        return "SalesforceLoginConfig[loginUrl='" + this.loginUrl + '\'' + ", clientId='" + this.clientId + '\'' + ", clientSecret='********', refreshToken='" + this.refreshToken + '\'' + ", userName='" + this.userName + '\'' + ", password=********'" + this.password + '\'' + ", keystore=********'" + this.keystore + '\'' + ", lazyLogin=" + this.lazyLogin + ']';
    }
}

