/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.NoSuchOptionException;
import org.apache.camel.component.servicenow.ServiceNowClient;
import org.apache.camel.component.servicenow.ServiceNowComponent;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowException;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.impl.verifier.DefaultComponentVerifier;
import org.apache.camel.impl.verifier.ResultBuilder;
import org.apache.camel.impl.verifier.ResultErrorBuilder;

public class ServiceNowComponentVerifier
extends DefaultComponentVerifier {
    private final ServiceNowComponent component;

    ServiceNowComponentVerifier(ServiceNowComponent component) {
        super("servicenow", component.getCamelContext());
        this.component = component;
    }

    protected ComponentVerifier.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.PARAMETERS);
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifier.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.CONNECTIVITY);
        try {
            String tableName;
            ServiceNowConfiguration configuration = new ServiceNowConfiguration();
            this.setProperties(configuration, parameters);
            String instanceName = (String)this.getMandatoryOption(parameters, "instanceName", String.class);
            String string = tableName = configuration.getTable() != null ? configuration.getTable() : "incident";
            if (!configuration.hasApiUrl()) {
                configuration.setApiUrl(String.format("https://%s.service-now.com/api", instanceName));
            }
            if (!configuration.hasOauthTokenUrl()) {
                configuration.setOauthTokenUrl(String.format("https://%s.service-now.com/oauth_token.do", instanceName));
            }
            new ServiceNowClient(this.getCamelContext(), configuration).types(MediaType.APPLICATION_JSON_TYPE).path("now").path(configuration.getApiVersion()).path("table").path(tableName).query(ServiceNowParams.SYSPARM_LIMIT.getId(), 1L).invoke("GET");
        }
        catch (NoSuchOptionException e) {
            builder.error(ResultErrorBuilder.withMissingOption((String)e.getOptionName()).build());
        }
        catch (ServiceNowException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withException((Exception)((Object)e)).detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.HttpAttribute.HTTP_CODE, (Object)e.getCode()).detail("servicenow_error_message", (Object)e.getMessage()).detail("servicenow_error_status", (Object)e.getStatus()).detail("servicenow_error_detail", (Object)e.getDetail());
            if (e.getCode() == 401) {
                errorBuilder.code((ComponentVerifier.VerificationError.Code)ComponentVerifier.VerificationError.StandardCode.AUTHENTICATION);
                errorBuilder.parameterKey("userName");
                errorBuilder.parameterKey("password");
                errorBuilder.parameterKey("oauthClientId");
                errorBuilder.parameterKey("oauthClientSecret");
            }
            builder.error(errorBuilder.build());
        }
        catch (Exception e) {
            builder.error(ResultErrorBuilder.withException((Exception)e).build());
        }
        return builder.build();
    }
}

