/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.handler.CamelNamespaceHandler;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public final class SpringCamelContextFactory {
    private SpringCamelContextFactory() {
    }

    public static SpringCamelContext createSingleCamelContext(URL contextUrl, ClassLoader classsLoader) throws Exception {
        List<SpringCamelContext> list = SpringCamelContextFactory.createCamelContextList((Resource)new UrlResource(contextUrl), classsLoader);
        IllegalStateAssertion.assertEquals((Object)1, (Object)list.size(), (String)("Single context expected in: " + contextUrl));
        return list.get(0);
    }

    public static List<SpringCamelContext> createCamelContextList(URL contextUrl, ClassLoader classsLoader) throws Exception {
        return SpringCamelContextFactory.createCamelContextList((Resource)new UrlResource(contextUrl), classsLoader);
    }

    public static List<SpringCamelContext> createCamelContextList(byte[] bytes, ClassLoader classsLoader) throws Exception {
        return SpringCamelContextFactory.createCamelContextList((Resource)new ByteArrayResource(bytes), classsLoader);
    }

    private static List<SpringCamelContext> createCamelContextList(Resource resource, ClassLoader classLoader) throws Exception {
        if (classLoader == null) {
            classLoader = SpringCamelContextFactory.class.getClassLoader();
        }
        GenericApplicationContext appContext = new GenericApplicationContext();
        appContext.setClassLoader(classLoader);
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext){

            protected NamespaceHandlerResolver createDefaultNamespaceHandlerResolver() {
                NamespaceHandlerResolver defaultResolver = super.createDefaultNamespaceHandlerResolver();
                return new CamelNamespaceHandlerResolver(defaultResolver);
            }
        };
        xmlReader.loadBeanDefinitions(resource);
        SpringCamelContext.setNoStart((boolean)true);
        appContext.refresh();
        ArrayList<Object> result = new ArrayList<Object>();
        for (String name : appContext.getBeanNamesForType(SpringCamelContext.class)) {
            result.add(appContext.getBean(name, SpringCamelContext.class));
        }
        return Collections.unmodifiableList(result);
    }

    private static class CamelNamespaceHandlerResolver
    implements NamespaceHandlerResolver {
        private final NamespaceHandlerResolver delegate;
        private final NamespaceHandler camelHandler;

        CamelNamespaceHandlerResolver(NamespaceHandlerResolver delegate) {
            this.delegate = delegate;
            this.camelHandler = new CamelNamespaceHandler();
            this.camelHandler.init();
        }

        public NamespaceHandler resolve(String namespaceUri) {
            if ("http://camel.apache.org/schema/spring".equals(namespaceUri)) {
                return this.camelHandler;
            }
            return this.delegate.resolve(namespaceUri);
        }
    }
}

