/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.validator.BeanValidatorProducer;
import org.apache.camel.component.bean.validator.ValidatorFactories;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.PlatformHelper;

@UriEndpoint(firstVersion="2.3.0", scheme="bean-validator", title="Bean Validator", syntax="bean-validator:label", producerOnly=true, label="validation")
public class BeanValidatorEndpoint
extends DefaultEndpoint {
    @UriPath(description="Where label is an arbitrary text value describing the endpoint")
    @Metadata(required="true")
    private String label;
    @UriParam(defaultValue="javax.validation.groups.Default")
    private String group;
    @UriParam
    private ValidationProviderResolver validationProviderResolver;
    @UriParam
    private MessageInterpolator messageInterpolator;
    @UriParam
    private TraversableResolver traversableResolver;
    @UriParam
    private ConstraintValidatorFactory constraintValidatorFactory;

    public BeanValidatorEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Producer createProducer() throws Exception {
        BeanValidatorProducer producer = new BeanValidatorProducer(this);
        if (this.group != null) {
            producer.setGroup(this.getCamelContext().getClassResolver().resolveMandatoryClass(this.group));
        }
        ValidatorFactory validatorFactory = ValidatorFactories.buildValidatorFactory(this.isOsgiContext(), this.validationProviderResolver, this.messageInterpolator, this.traversableResolver, this.constraintValidatorFactory);
        producer.setValidatorFactory(validatorFactory);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not supported");
    }

    public boolean isSingleton() {
        return true;
    }

    protected boolean isOsgiContext() {
        return PlatformHelper.isOsgiContext((CamelContext)this.getCamelContext());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ValidationProviderResolver getValidationProviderResolver() {
        return this.validationProviderResolver;
    }

    public void setValidationProviderResolver(ValidationProviderResolver validationProviderResolver) {
        this.validationProviderResolver = validationProviderResolver;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public void setTraversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }
}

