/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.io.BufferPool;
import org.wildfly.swarm.config.io.BufferPoolConsumer;
import org.wildfly.swarm.config.io.BufferPoolSupplier;
import org.wildfly.swarm.config.io.Worker;
import org.wildfly.swarm.config.io.WorkerConsumer;
import org.wildfly.swarm.config.io.WorkerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=io")
@ResourceType(value="subsystem")
@Implicit
public class IO<T extends IO<T>>
extends HashMap
implements Keyed {
    private String key = "io";
    private PropertyChangeSupport pcs;
    private IOResources subresources = new IOResources();

    public IO() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public IOResources subresources() {
        return this.subresources;
    }

    public T workers(List<Worker> value) {
        this.subresources.workers = value;
        return (T)this;
    }

    public T worker(Worker value) {
        this.subresources.workers.add(value);
        return (T)this;
    }

    public T worker(String childKey, WorkerConsumer consumer) {
        Worker child = new Worker(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.worker(child);
        return (T)this;
    }

    public T worker(String childKey) {
        this.worker(childKey, null);
        return (T)this;
    }

    public T worker(WorkerSupplier supplier) {
        this.worker(supplier.get());
        return (T)this;
    }

    public T bufferPools(List<BufferPool> value) {
        this.subresources.bufferPools = value;
        return (T)this;
    }

    public T bufferPool(BufferPool value) {
        this.subresources.bufferPools.add(value);
        return (T)this;
    }

    public T bufferPool(String childKey, BufferPoolConsumer consumer) {
        BufferPool child = new BufferPool(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.bufferPool(child);
        return (T)this;
    }

    public T bufferPool(String childKey) {
        this.bufferPool(childKey, null);
        return (T)this;
    }

    public T bufferPool(BufferPoolSupplier supplier) {
        this.bufferPool(supplier.get());
        return (T)this;
    }

    public static class IOResources {
        @ResourceDocumentation(value="Defines workers")
        @SubresourceInfo(value="worker")
        private List<Worker> workers = new ArrayList<Worker>();
        @ResourceDocumentation(value="Defines buffer pool")
        @SubresourceInfo(value="bufferPool")
        private List<BufferPool> bufferPools = new ArrayList<BufferPool>();

        @Subresource
        public List<Worker> workers() {
            return this.workers;
        }

        public Worker worker(String key) {
            return this.workers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<BufferPool> bufferPools() {
            return this.bufferPools;
        }

        public BufferPool bufferPool(String key) {
            return this.bufferPools.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

