/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ejb3;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=ejb3/cache=*")
@ResourceType(value="cache")
public class Cache<T extends Cache<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The aliases by which this cache may also be referenced")
    private List<String> aliases;
    @AttributeDocumentation(value="The passivation store used by this cache")
    private String passivationStore;

    public Cache(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="aliases")
    public List<String> aliases() {
        return this.aliases;
    }

    public T aliases(List<String> value) {
        List<String> oldValue = this.aliases;
        this.aliases = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("aliases", oldValue, value);
        }
        return (T)this;
    }

    public T alias(String value) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(value);
        return (T)this;
    }

    public T aliases(String ... args) {
        this.aliases(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="passivation-store")
    public String passivationStore() {
        return this.passivationStore;
    }

    public T passivationStore(String value) {
        String oldValue = this.passivationStore;
        this.passivationStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("passivationStore", oldValue, value);
        }
        return (T)this;
    }
}

