/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.jgroups.stack.relay;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.jgroups.Property;
import org.wildfly.swarm.config.jgroups.PropertyConsumer;
import org.wildfly.swarm.config.jgroups.PropertySupplier;
import org.wildfly.swarm.config.jgroups.stack.relay.RemoteSite;
import org.wildfly.swarm.config.jgroups.stack.relay.RemoteSiteConsumer;
import org.wildfly.swarm.config.jgroups.stack.relay.RemoteSiteSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=jgroups/stack=*/relay=relay.RELAY2")
@ResourceType(value="relay")
@Implicit
public class RELAY2<T extends RELAY2<T>>
extends HashMap
implements Keyed {
    private String key = "relay.RELAY2";
    private PropertyChangeSupport pcs;
    private RELAY2Resources subresources = new RELAY2Resources();
    @AttributeDocumentation(value="The properties of this protocol.")
    private Map properties;
    @AttributeDocumentation(value="The name of the local site.")
    private String site;

    public RELAY2() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public RELAY2Resources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    public T remoteSites(List<RemoteSite> value) {
        this.subresources.remoteSites = value;
        return (T)this;
    }

    public T remoteSite(RemoteSite value) {
        this.subresources.remoteSites.add(value);
        return (T)this;
    }

    public T remoteSite(String childKey, RemoteSiteConsumer consumer) {
        RemoteSite child = new RemoteSite(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.remoteSite(child);
        return (T)this;
    }

    public T remoteSite(String childKey) {
        this.remoteSite(childKey, null);
        return (T)this;
    }

    public T remoteSite(RemoteSiteSupplier supplier) {
        this.remoteSite(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="site")
    public String site() {
        return this.site;
    }

    public T site(String value) {
        String oldValue = this.site;
        this.site = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("site", oldValue, value);
        }
        return (T)this;
    }

    public static class RELAY2Resources {
        @ResourceDocumentation(value="A protocol property with name and value.")
        @SubresourceInfo(value="property")
        private List<Property> properties = new ArrayList<Property>();
        @ResourceDocumentation(value="A remote site to which to bridge.")
        @SubresourceInfo(value="remoteSite")
        private List<RemoteSite> remoteSites = new ArrayList<RemoteSite>();

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RemoteSite> remoteSites() {
            return this.remoteSites;
        }

        public RemoteSite remoteSite(String key) {
            return this.remoteSites.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

