/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.security_realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/core-service=management/security-realm=*/authorization=properties")
@ResourceType(value="authorization")
@Implicit
public class PropertiesAuthorization<T extends PropertiesAuthorization<T>>
extends HashMap
implements Keyed {
    private String key = "properties";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The path of the properties file containing the users roles.")
    private String path;
    @AttributeDocumentation(value="The name of another previously named path, or of one of the standard paths provided by the system. If 'relative-to' is provided, the value of the 'path' attribute is treated as relative to the path specified by this attribute.")
    private String relativeTo;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="path")
    public String path() {
        return this.path;
    }

    public T path(String value) {
        String oldValue = this.path;
        this.path = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("path", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="relative-to")
    public String relativeTo() {
        return this.relativeTo;
    }

    public T relativeTo(String value) {
        String oldValue = this.relativeTo;
        this.relativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("relativeTo", oldValue, value);
        }
        return (T)this;
    }
}

