/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.security_realm.server_identity;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/core-service=management/security-realm=*/server-identity=kerberos/keytab=*")
@ResourceType(value="keytab")
public class Keytab<T extends Keytab<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Should additional debug logging be enabled during TGT acquisition?")
    private Boolean debug;
    @AttributeDocumentation(value="A server can be accessed using different host names, this attribute specifies which host names this keytab can be used with.")
    private List<String> forHosts;
    @AttributeDocumentation(value="The path to the keytab.")
    private String path;
    @AttributeDocumentation(value="The name of another previously named path, or of one of the standard paths provided by the system. If 'relative-to' is provided, the value of the 'path' attribute is treated as relative to the path specified by this attribute.")
    private String relativeTo;

    public Keytab(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="debug")
    public Boolean debug() {
        return this.debug;
    }

    public T debug(Boolean value) {
        Boolean oldValue = this.debug;
        this.debug = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("debug", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="for-hosts")
    public List<String> forHosts() {
        return this.forHosts;
    }

    public T forHosts(List<String> value) {
        List<String> oldValue = this.forHosts;
        this.forHosts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("forHosts", oldValue, value);
        }
        return (T)this;
    }

    public T forHost(String value) {
        if (this.forHosts == null) {
            this.forHosts = new ArrayList<String>();
        }
        this.forHosts.add(value);
        return (T)this;
    }

    public T forHosts(String ... args) {
        this.forHosts(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="path")
    public String path() {
        return this.path;
    }

    public T path(String value) {
        String oldValue = this.path;
        this.path = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("path", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="relative-to")
    public String relativeTo() {
        return this.relativeTo;
    }

    public T relativeTo(String value) {
        String oldValue = this.relativeTo;
        this.relativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("relativeTo", oldValue, value);
        }
        return (T)this;
    }
}

