/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.producer.AbstractGitHubProducer;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.IssueService;

public class CreateIssueProducer
extends AbstractGitHubProducer {
    private IssueService issueService;

    public CreateIssueProducer(GitHubEndpoint endpoint) throws Exception {
        super(endpoint);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githbIssueService");
        this.issueService = service != null ? (IssueService)service : new IssueService();
        this.initService((GitHubService)this.issueService);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Issue issue = new Issue();
        String issueTitle = (String)exchange.getIn().getHeader("GitHubIssueTitle", String.class);
        if (ObjectHelper.isEmpty((Object)issueTitle)) {
            throw new IllegalArgumentException("Issue Title must be specified to create an issue");
        }
        issue.setTitle(issueTitle);
        issue.setBody((String)exchange.getIn().getBody(String.class));
        Issue finalIssue = this.issueService.createIssue((IRepositoryIdProvider)this.getRepository(), issue);
        exchange.getOut().copyFrom(exchange.getIn());
        exchange.getOut().setBody((Object)finalIssue);
    }
}

