/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.producer.AbstractGitHubProducer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.CommitStatus;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.GitHubService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestStateProducer
extends AbstractGitHubProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(PullRequestStateProducer.class);
    private CommitService commitService;
    private String state;
    private String targetUrl;

    public PullRequestStateProducer(GitHubEndpoint endpoint) throws Exception {
        super(endpoint);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubCommitService");
        if (service != null) {
            LOG.debug("Using CommitService found in registry " + service.getClass().getCanonicalName());
            this.commitService = (CommitService)service;
        } else {
            this.commitService = new CommitService();
        }
        this.initService((GitHubService)this.commitService);
        this.state = endpoint.getState();
        this.targetUrl = endpoint.getTargetUrl();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String pullRequestNumberSHA = (String)exchange.getIn().getHeader("GitHubPullRequestHeadCommitSHA", String.class);
        String text = (String)exchange.getIn().getBody(String.class);
        CommitStatus status = new CommitStatus();
        if (this.state != null) {
            status.setState(this.state);
        }
        if (this.targetUrl != null) {
            status.setTargetUrl(this.targetUrl);
        }
        if (text != null) {
            status.setDescription(text);
        }
        CommitStatus response = this.commitService.createStatus((IRepositoryIdProvider)this.getRepository(), pullRequestNumberSHA, status);
        exchange.getOut().copyFrom(exchange.getIn());
        exchange.getOut().setBody((Object)response);
    }
}

