/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl.local;

import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wscf.exceptions.ProtocolNotRegisteredException;
import com.arjuna.mw.wscf.model.sagas.exceptions.CoordinatorCancelledException;
import com.arjuna.mw.wscf.model.sagas.participants.Participant;
import com.arjuna.mw.wscf11.model.sagas.CoordinatorManagerFactory;
import java.util.UUID;
import org.jboss.narayana.compensations.api.CompensationHandler;
import org.jboss.narayana.compensations.api.ConfirmationHandler;
import org.jboss.narayana.compensations.api.TransactionCompensatedException;
import org.jboss.narayana.compensations.api.TransactionLoggedHandler;
import org.jboss.narayana.compensations.impl.BAController;
import org.jboss.narayana.compensations.impl.BeanManagerUtil;
import org.jboss.narayana.compensations.impl.CompensationManagerImpl;
import org.jboss.narayana.compensations.impl.CompensationManagerState;
import org.jboss.narayana.compensations.impl.ParticipantManager;
import org.jboss.narayana.compensations.impl.local.LocalParticipant;
import org.jboss.narayana.compensations.impl.local.LocalParticipantManager;

public class LocalBAController
implements BAController {
    @Override
    public void beginBusinessActivity() throws Exception {
        CoordinatorManagerFactory.coordinatorManager().begin("Sagas11HLS");
        CompensationManagerImpl.resume(new CompensationManagerState());
    }

    @Override
    public void closeBusinessActivity() throws Exception {
        CoordinatorManagerFactory.coordinatorManager().close();
        CompensationManagerImpl.suspend();
    }

    @Override
    public void cancelBusinessActivity() throws Exception {
        CoordinatorManagerFactory.coordinatorManager().cancel();
        CompensationManagerImpl.suspend();
    }

    @Override
    public void completeBusinessActivity(boolean isException) throws Exception {
        if (CompensationManagerImpl.isCompensateOnly() && !isException) {
            this.cancelBusinessActivity();
            throw new TransactionCompensatedException("Transaction was marked as 'compensate only'");
        }
        if (CompensationManagerImpl.isCompensateOnly()) {
            this.cancelBusinessActivity();
        } else {
            try {
                this.closeBusinessActivity();
            }
            catch (CoordinatorCancelledException e) {
                throw new TransactionCompensatedException("Failed to close transaction", e);
            }
        }
    }

    @Override
    public boolean isBARunning() {
        try {
            return CoordinatorManagerFactory.coordinatorManager().currentActivity() != null;
        }
        catch (SystemException e) {
            return false;
        }
        catch (ProtocolNotRegisteredException e) {
            return false;
        }
    }

    @Override
    public Object suspend() throws Exception {
        return CoordinatorManagerFactory.coordinatorManager().suspend();
    }

    @Override
    public void resume(Object context) throws Exception {
        CoordinatorManagerFactory.coordinatorManager().resume((ActivityHierarchy)context);
    }

    @Override
    public Object getCurrentTransaction() throws Exception {
        return CoordinatorManagerFactory.coordinatorManager().currentActivity();
    }

    @Override
    public ParticipantManager enlist(Class<? extends CompensationHandler> compensationHandlerClass, Class<? extends ConfirmationHandler> confirmationHandlerClass, Class<? extends TransactionLoggedHandler> transactionLoggedHandlerClass) throws Exception {
        CompensationHandler compensationHandler = this.instantiate(compensationHandlerClass);
        ConfirmationHandler confirmationHandler = this.instantiate(confirmationHandlerClass);
        TransactionLoggedHandler transactionLoggedHandler = this.instantiate(transactionLoggedHandlerClass);
        return this.enlist(compensationHandler, confirmationHandler, transactionLoggedHandler);
    }

    @Override
    public ParticipantManager enlist(CompensationHandler compensationHandler, ConfirmationHandler confirmationHandler, TransactionLoggedHandler transactionLoggedHandler) throws Exception {
        String participantId = String.valueOf(UUID.randomUUID());
        LocalParticipant participant = new LocalParticipant(compensationHandler, confirmationHandler, transactionLoggedHandler, this.getCurrentTransaction(), participantId);
        CoordinatorManagerFactory.coordinatorManager().enlistParticipant((Participant)participant);
        return new LocalParticipantManager(participantId);
    }

    private <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return BeanManagerUtil.createBeanInstance(clazz);
    }
}

