package org.jboss.as.logging.logging;

import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logmanager.Configurator;
import java.io.Closeable;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.as.controller.registry.Resource.NoSuchResourceException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.logging.Target;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.annotation.Generated;
import java.util.EnumSet;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logmanager.LogContext;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import java.util.Collection;
import java.lang.Class;
import java.util.Arrays;
import java.io.File;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-03-21T14:57:50-0500")
public class LoggingLogger_$logger extends DelegatingBasicLogger implements LoggingLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LoggingLogger_$logger.class.getName();
    public LoggingLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void errorSettingProperty(final Throwable cause, final String propertyName, final String className) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, errorSettingProperty$str(), propertyName, className);
    }
    private static final String errorSettingProperty = "WFLYLOG0002: An error occurred trying to set the property '%s' on handler '%s'.";
    protected String errorSettingProperty$str() {
        return errorSettingProperty;
    }
    @Override
    public final void unknownProperty(final String propertyName, final String className) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, unknownProperty$str(), propertyName, className);
    }
    private static final String unknownProperty = "WFLYLOG0005: Unknown property '%s' for '%s'.";
    protected String unknownProperty$str() {
        return unknownProperty;
    }
    @Override
    public final void failedToCloseResource(final Throwable cause, final Closeable closeable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, failedToCloseResource$str(), closeable);
    }
    private static final String failedToCloseResource = "WFLYLOG0006: Failed to close resource %s";
    protected String failedToCloseResource$str() {
        return failedToCloseResource;
    }
    @Override
    public final void invalidPropertyAttribute(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, invalidPropertyAttribute$str(), name);
    }
    private static final String invalidPropertyAttribute = "WFLYLOG0007: The attribute %s could not be set as it is not a configurable property value.";
    protected String invalidPropertyAttribute$str() {
        return invalidPropertyAttribute;
    }
    private static final String pathManagerServiceNotStarted = "WFLYLOG0008: The path manager service does not appear to be started. Any changes may be lost as a result of this.";
    protected String pathManagerServiceNotStarted$str() {
        return pathManagerServiceNotStarted;
    }
    @Override
    public final String pathManagerServiceNotStarted() {
        return String.format(pathManagerServiceNotStarted$str());
    }
    @Override
    public final void filterNotSupported() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, filterNotSupported$str());
    }
    private static final String filterNotSupported = "WFLYLOG0009: Filters are not currently supported for log4j appenders.";
    protected String filterNotSupported$str() {
        return filterNotSupported;
    }
    @Override
    public final void loggingProfileNotFound(final String loggingProfile, final ResourceRoot deployment) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, loggingProfileNotFound$str(), loggingProfile, deployment);
    }
    private static final String loggingProfileNotFound = "WFLYLOG0010: Logging profile '%s' was specified for deployment '%s' but was not found. Using system logging configuration.";
    protected String loggingProfileNotFound$str() {
        return loggingProfileNotFound;
    }
    @Override
    public final void julConfigurationFileFound(final String fileName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, julConfigurationFileFound$str(), fileName);
    }
    private static final String julConfigurationFileFound = "WFLYLOG0011: The configuration file in '%s' appears to be a J.U.L. configuration file. The log manager does not allow this type of configuration file.";
    protected String julConfigurationFileFound$str() {
        return julConfigurationFileFound;
    }
    @Override
    public final void replacingNamedHandler(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, replacingNamedHandler$str(), name);
    }
    private static final String replacingNamedHandler = "WFLYLOG0012: Replacing handler '%s' during add operation. Either the handler type or the module name differs from the initial configuration.";
    protected String replacingNamedHandler$str() {
        return replacingNamedHandler;
    }
    @Override
    public final void replacingConfigurator(final Configurator c) {
        if (super.log.isEnabled(org.jboss.logging.Logger.Level.WARN)) {
            final Class<? extends Object> cClass;
            if (c == null) {
                cClass = null;
            }
            else cClass = c.getClass();

            super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, replacingConfigurator$str(), cClass);
        }
    }
    private static final String replacingConfigurator = "WFLYLOG0013: A configurator class, '%s', is not a known configurator and will be replaced.";
    protected String replacingConfigurator$str() {
        return replacingConfigurator;
    }
    @Override
    public final void logContextNotRemoved(final LogContext logContext, final String deploymentName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, null, logContextNotRemoved$str(), logContext, deploymentName);
    }
    private static final String logContextNotRemoved = "WFLYLOG0014: The log context (%s) could not be removed for deployment %s";
    protected String logContextNotRemoved$str() {
        return logContextNotRemoved;
    }
    @Override
    public final void perDeploymentPropertyDeprecated(final String propertyName, final String attributeName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, perDeploymentPropertyDeprecated$str(), propertyName, attributeName);
    }
    private static final String perDeploymentPropertyDeprecated = "WFLYLOG0015: The per-logging deployment property (%s) has been deprecated. Please use the %s attribute to enable/disable per-deployment logging.";
    protected String perDeploymentPropertyDeprecated$str() {
        return perDeploymentPropertyDeprecated;
    }
    @Override
    public final void perLoggingDeploymentIgnored(final String propertyName, final String attributeName, final String deploymentName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, perLoggingDeploymentIgnored$str(), propertyName, attributeName, deploymentName);
    }
    private static final String perLoggingDeploymentIgnored = "WFLYLOG0016: The per-logging deployment property (%s) is being ignored because the attribute %s has been set to ignore configuration files in the deployment %s.";
    protected String perLoggingDeploymentIgnored$str() {
        return perLoggingDeploymentIgnored;
    }
    private static final String cannotAccessClass = "WFLYLOG0017: Could not access %s.";
    protected String cannotAccessClass$str() {
        return cannotAccessClass;
    }
    @Override
    public final String cannotAccessClass(final Throwable cause, final String className) {
        return String.format(cannotAccessClass$str(), className);
    }
    private static final String cannotInstantiateClass = "WFLYLOG0018: Failed to instantiate class '%s' for %s '%s'";
    protected String cannotInstantiateClass$str() {
        return cannotInstantiateClass;
    }
    @Override
    public final IllegalArgumentException cannotInstantiateClass(final Throwable cause, final String className, final String description, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotInstantiateClass$str(), className, description, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadModule = "WFLYLOG0019: Failed to load module '%s' for %s '%s'";
    protected String cannotLoadModule$str() {
        return cannotLoadModule;
    }
    @Override
    public final IllegalArgumentException cannotLoadModule(final Throwable cause, final String moduleName, final String description, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotLoadModule$str(), moduleName, description, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUnassignHandler = "WFLYLOG0020: Can not unassign handler. Handler %s is not assigned.";
    protected String cannotUnassignHandler$str() {
        return cannotUnassignHandler;
    }
    @Override
    public final String cannotUnassignHandler(final String handlerName) {
        return String.format(cannotUnassignHandler$str(), handlerName);
    }
    private static final String classNotFound = "WFLYLOG0021: Class '%s' could not be found.";
    protected String classNotFound$str() {
        return classNotFound;
    }
    @Override
    public final String classNotFound(final Throwable cause, final String className) {
        return String.format(classNotFound$str(), className);
    }
    private static final String failedToSetHandlerEncoding = "WFLYLOG0022: The encoding value '%s' is invalid.";
    protected String failedToSetHandlerEncoding$str() {
        return failedToSetHandlerEncoding;
    }
    @Override
    public final IllegalArgumentException failedToSetHandlerEncoding(final Throwable cause, final String encoding) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(failedToSetHandlerEncoding$str(), encoding), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerAlreadyDefined = "WFLYLOG0023: Handler %s is already assigned.";
    protected String handlerAlreadyDefined$str() {
        return handlerAlreadyDefined;
    }
    @Override
    public final String handlerAlreadyDefined(final String name) {
        return String.format(handlerAlreadyDefined$str(), name);
    }
    private static final String handlerNotFound = "WFLYLOG0024: Handler %s not found.";
    protected String handlerNotFound$str() {
        return handlerNotFound;
    }
    @Override
    public final IllegalArgumentException handlerNotFound(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(handlerNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFilter = "WFLYLOG0025: Filter %s is invalid";
    protected String invalidFilter$str() {
        return invalidFilter;
    }
    @Override
    public final String invalidFilter(final String name) {
        return String.format(invalidFilter$str(), name);
    }
    private static final String invalidLogLevel = "WFLYLOG0026: Log level %s is invalid.";
    protected String invalidLogLevel$str() {
        return invalidLogLevel;
    }
    @Override
    public final String invalidLogLevel(final String level) {
        return String.format(invalidLogLevel$str(), level);
    }
    private static final String invalidOverflowAction = "WFLYLOG0027: Overflow action %s is invalid.";
    protected String invalidOverflowAction$str() {
        return invalidOverflowAction;
    }
    @Override
    public final String invalidOverflowAction(final String overflowAction) {
        return String.format(invalidOverflowAction$str(), overflowAction);
    }
    private static final String invalidSize = "WFLYLOG0028: Invalid size %s";
    protected String invalidSize$str() {
        return invalidSize;
    }
    @Override
    public final String invalidSize(final String size) {
        return String.format(invalidSize$str(), size);
    }
    private static final String invalidTargetName = "WFLYLOG0029: Invalid value for target name. Valid names include: %s";
    protected String invalidTargetName$str() {
        return invalidTargetName;
    }
    @Override
    public final String invalidTargetName(final EnumSet<Target> targets) {
        return String.format(invalidTargetName$str(), targets);
    }
    private static final String invalidValueTypeKey = "WFLYLOG0031: Value type key '%s' is invalid. Valid value type keys are; %s";
    protected String invalidValueTypeKey$str() {
        return invalidValueTypeKey;
    }
    @Override
    public final String invalidValueTypeKey(final String key, final Collection<String> allowedValues) {
        return String.format(invalidValueTypeKey$str(), key, allowedValues);
    }
    private static final String missingRequiredNestedFilterElement = "WFLYLOG0032: Missing required nested filter element";
    protected String missingRequiredNestedFilterElement$str() {
        return missingRequiredNestedFilterElement;
    }
    @Override
    public final String missingRequiredNestedFilterElement() {
        return String.format(missingRequiredNestedFilterElement$str());
    }
    private static final String unknownParameterType = "WFLYLOG0034: Unknown parameter type (%s) for property '%s' on '%s'";
    protected String unknownParameterType$str() {
        return unknownParameterType;
    }
    @Override
    public final IllegalArgumentException unknownParameterType(final Class<? extends Object> type, final String propertyName, final Class<? extends Object> clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unknownParameterType$str(), type, propertyName, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String loggerNotFound = "WFLYLOG0035: Logger '%s' was not found.";
    protected String loggerNotFound$str() {
        return loggerNotFound;
    }
    @Override
    public final String loggerNotFound(final String name) {
        return String.format(loggerNotFound$str(), name);
    }
    private static final String invalidRelativeTo = "WFLYLOG0039: An absolute path (%s) cannot be specified for relative-to.";
    protected String invalidRelativeTo$str() {
        return invalidRelativeTo;
    }
    @Override
    public final String invalidRelativeTo(final String relativeTo) {
        return String.format(invalidRelativeTo$str(), relativeTo);
    }
    private static final String invalidPath = "WFLYLOG0040: An absolute path (%2$s) cannot be used when a relative-to path (%1$s) is being used.";
    protected String invalidPath$str() {
        return invalidPath;
    }
    @Override
    public final String invalidPath(final String relativeTo, final String path) {
        return String.format(invalidPath$str(), relativeTo, path);
    }
    private static final String invalidSuffix = "WFLYLOG0041: The suffix (%s) is invalid. A suffix must be a valid date format.";
    protected String invalidSuffix$str() {
        return invalidSuffix;
    }
    @Override
    public final String invalidSuffix(final String suffix) {
        return String.format(invalidSuffix$str(), suffix);
    }
    private static final String failedToConfigureLogging = "WFLYLOG0042: Failed to configure logging using '%s' configuration file.";
    protected String failedToConfigureLogging$str() {
        return failedToConfigureLogging;
    }
    @Override
    public final DeploymentUnitProcessingException failedToConfigureLogging(final Throwable cause, final String fileName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(failedToConfigureLogging$str(), fileName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorProcessingLoggingConfiguration = "WFLYLOG0043: Error occurred while searching for logging configuration files.";
    protected String errorProcessingLoggingConfiguration$str() {
        return errorProcessingLoggingConfiguration;
    }
    @Override
    public final DeploymentUnitProcessingException errorProcessingLoggingConfiguration(final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(errorProcessingLoggingConfiguration$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerAttachedToHandlers = "WFLYLOG0044: Handler %s is attached to the following handlers and cannot be removed; %s";
    protected String handlerAttachedToHandlers$str() {
        return handlerAttachedToHandlers;
    }
    @Override
    public final OperationFailedException handlerAttachedToHandlers(final String handlerName, final Collection<String> handlers) {
        final OperationFailedException result = new OperationFailedException(String.format(handlerAttachedToHandlers$str(), handlerName, handlers));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerAttachedToLoggers = "WFLYLOG0045: Handler %s is attached to the following loggers and cannot be removed; %s";
    protected String handlerAttachedToLoggers$str() {
        return handlerAttachedToLoggers;
    }
    @Override
    public final OperationFailedException handlerAttachedToLoggers(final String handlerName, final Collection<String> loggers) {
        final OperationFailedException result = new OperationFailedException(String.format(handlerAttachedToLoggers$str(), handlerName, loggers));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddHandlerToSelf = "WFLYLOG0046: Cannot add handler (%s) to itself";
    protected String cannotAddHandlerToSelf$str() {
        return cannotAddHandlerToSelf;
    }
    @Override
    public final String cannotAddHandlerToSelf(final String handlerName) {
        return String.format(cannotAddHandlerToSelf$str(), handlerName);
    }
    private static final String handlerClosed0 = "WFLYLOG0047: The handler is closed, cannot publish to a closed handler";
    protected String handlerClosed0$str() {
        return handlerClosed0;
    }
    @Override
    public final IllegalStateException handlerClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(handlerClosed0$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerClosed2 = "WFLYLOG0047: Cannot set property '%s' on a closed handler with value '%s'.";
    protected String handlerClosed2$str() {
        return handlerClosed2;
    }
    @Override
    public final IllegalStateException handlerClosed(final String name, final String value) {
        final IllegalStateException result = new IllegalStateException(String.format(handlerClosed2$str(), name, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerConfigurationNotFound = "WFLYLOG0048: Configuration for handler '%s' could not be found.";
    protected String handlerConfigurationNotFound$str() {
        return handlerConfigurationNotFound;
    }
    @Override
    public final String handlerConfigurationNotFound(final String name) {
        return String.format(handlerConfigurationNotFound$str(), name);
    }
    private static final String loggerConfigurationNotFound = "WFLYLOG0049: Configuration for logger '%s' could not be found.";
    protected String loggerConfigurationNotFound$str() {
        return loggerConfigurationNotFound;
    }
    @Override
    public final String loggerConfigurationNotFound(final String name) {
        return String.format(loggerConfigurationNotFound$str(), name);
    }
    private static final String unsupportedMethod = "WFLYLOG0050: Method %s on class %s is not supported";
    protected String unsupportedMethod$str() {
        return unsupportedMethod;
    }
    @Override
    public final UnsupportedOperationException unsupportedMethod(final String methodName, final String className) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(unsupportedMethod$str(), methodName, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToWriteConfigurationFile = "WFLYLOG0051: Failed to write configuration file %s";
    protected String failedToWriteConfigurationFile$str() {
        return failedToWriteConfigurationFile;
    }
    @Override
    public final RuntimeException failedToWriteConfigurationFile(final Throwable e, final File fileName) {
        final RuntimeException result = new RuntimeException(String.format(failedToWriteConfigurationFile$str(), fileName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackFailure = "WFLYLOG0052: A failure was detecting while performing a rollback.";
    protected String rollbackFailure$str() {
        return rollbackFailure;
    }
    @Override
    public final RuntimeException rollbackFailure(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(rollbackFailure$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullVar = "WFLYLOG0053: %s is null";
    protected String nullVar$str() {
        return nullVar;
    }
    @Override
    public final IllegalArgumentException nullVar(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(nullVar$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadClass = "WFLYLOG0054: Failed to load class '%s' for %s '%s'";
    protected String failedToLoadClass$str() {
        return failedToLoadClass;
    }
    @Override
    public final IllegalArgumentException failedToLoadClass(final Throwable cause, final String className, final String description, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(failedToLoadClass$str(), className, description, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidProperty = "WFLYLOG0055: No property named '%s' for %s '%s' of type '%s'";
    protected String invalidProperty$str() {
        return invalidProperty;
    }
    @Override
    public final IllegalArgumentException invalidProperty(final String propertyName, final String description, final String name, final Class<? extends Object> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidProperty$str(), propertyName, description, name, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLocateConstructor = "WFLYLOG0056: Failed to locate constructor in class \"%s\" for %s \"%s\"";
    protected String failedToLocateConstructor$str() {
        return failedToLocateConstructor;
    }
    @Override
    public final IllegalArgumentException failedToLocateConstructor(final Throwable cause, final String className, final String description, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(failedToLocateConstructor$str(), className, description, name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSetRemovedProperty = "WFLYLOG0057: Cannot set property '%s' on %s '%s' (removed)";
    protected String cannotSetRemovedProperty$str() {
        return cannotSetRemovedProperty;
    }
    @Override
    public final IllegalArgumentException cannotSetRemovedProperty(final String propertyName, final String description, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotSetRemovedProperty$str(), propertyName, description, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertySetterNotFound = "WFLYLOG0058: No property '%s' setter found for %s '%s'";
    protected String propertySetterNotFound$str() {
        return propertySetterNotFound;
    }
    @Override
    public final IllegalArgumentException propertySetterNotFound(final String propertyName, final String description, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(propertySetterNotFound$str(), propertyName, description, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertyTypeNotFound = "WFLYLOG0059: No property '%s' type could be determined for %s '%s'";
    protected String propertyTypeNotFound$str() {
        return propertyTypeNotFound;
    }
    @Override
    public final IllegalArgumentException propertyTypeNotFound(final String propertyName, final String description, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(propertyTypeNotFound$str(), propertyName, description, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertyAlreadyRemoved = "WFLYLOG0060: Cannot remove property '%s' on %s '%s' (removed)";
    protected String propertyAlreadyRemoved$str() {
        return propertyAlreadyRemoved;
    }
    @Override
    public final IllegalArgumentException propertyAlreadyRemoved(final String propertyName, final String description, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(propertyAlreadyRemoved$str(), propertyName, description, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String formatterNotFound = "WFLYLOG0061: Formatter '%s' is not found";
    protected String formatterNotFound$str() {
        return formatterNotFound;
    }
    @Override
    public final String formatterNotFound(final String name) {
        return String.format(formatterNotFound$str(), name);
    }
    private static final String unsupportedCharSet = "WFLYLOG0062: Unsupported character set '%s'";
    protected String unsupportedCharSet$str() {
        return unsupportedCharSet;
    }
    @Override
    public final IllegalArgumentException unsupportedCharSet(final String encoding) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unsupportedCharSet$str(), encoding));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorManagerNotFound = "WFLYLOG0063: Error manager '%s' is not found";
    protected String errorManagerNotFound$str() {
        return errorManagerNotFound;
    }
    @Override
    public final IllegalArgumentException errorManagerNotFound(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(errorManagerNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nestedHandlersNotSupported = "WFLYLOG0064: Nested handlers not supported for handler %s";
    protected String nestedHandlersNotSupported$str() {
        return nestedHandlersNotSupported;
    }
    @Override
    public final IllegalArgumentException nestedHandlersNotSupported(final Class<? extends java.util.logging.Handler> handlerClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(nestedHandlersNotSupported$str(), handlerClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String loggerAlreadyExists = "WFLYLOG0065: Logger '%s' already exists";
    protected String loggerAlreadyExists$str() {
        return loggerAlreadyExists;
    }
    @Override
    public final IllegalArgumentException loggerAlreadyExists(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(loggerAlreadyExists$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String formatterAlreadyExists = "WFLYLOG0066: Formatter '%s' already exists";
    protected String formatterAlreadyExists$str() {
        return formatterAlreadyExists;
    }
    @Override
    public final IllegalArgumentException formatterAlreadyExists(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(formatterAlreadyExists$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String filterAlreadyExists = "WFLYLOG0067: Filter '%s' already exists";
    protected String filterAlreadyExists$str() {
        return filterAlreadyExists;
    }
    @Override
    public final IllegalArgumentException filterAlreadyExists(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(filterAlreadyExists$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorManagerAlreadyExists = "WFLYLOG0068: ErrorManager '%s' already exists";
    protected String errorManagerAlreadyExists$str() {
        return errorManagerAlreadyExists;
    }
    @Override
    public final IllegalArgumentException errorManagerAlreadyExists(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(errorManagerAlreadyExists$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAssignNullToPrimitive = "WFLYLOG0069: Cannot assign null value to primitive property '%s' of %s";
    protected String cannotAssignNullToPrimitive$str() {
        return cannotAssignNullToPrimitive;
    }
    @Override
    public final IllegalArgumentException cannotAssignNullToPrimitive(final String name, final Class<? extends Object> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotAssignNullToPrimitive$str(), name, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String truncatedFilterExpression = "WFLYLOG0070: Truncated filter expression string";
    protected String truncatedFilterExpression$str() {
        return truncatedFilterExpression;
    }
    @Override
    public final IllegalArgumentException truncatedFilterExpression() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(truncatedFilterExpression$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEscapeFoundInFilterExpression = "WFLYLOG0071: Invalid escape found in filter expression string";
    protected String invalidEscapeFoundInFilterExpression$str() {
        return invalidEscapeFoundInFilterExpression;
    }
    @Override
    public final IllegalArgumentException invalidEscapeFoundInFilterExpression() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidEscapeFoundInFilterExpression$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String filterNotFound = "WFLYLOG0072: Filter '%s' is not found";
    protected String filterNotFound$str() {
        return filterNotFound;
    }
    @Override
    public final IllegalArgumentException filterNotFound(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(filterNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedIdentifier = "WFLYLOG0073: Expected identifier next in filter expression";
    protected String expectedIdentifier$str() {
        return expectedIdentifier;
    }
    @Override
    public final IllegalArgumentException expectedIdentifier() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(expectedIdentifier$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedString = "WFLYLOG0074: Expected string next in filter expression";
    protected String expectedString$str() {
        return expectedString;
    }
    @Override
    public final IllegalArgumentException expectedString() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(expectedString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expected1 = "WFLYLOG0075: Expected '%s' next in filter expression";
    protected String expected1$str() {
        return expected1;
    }
    @Override
    public final IllegalArgumentException expected(final String token) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(expected1$str(), token));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expected2 = "WFLYLOG0075: Expected '%s' or '%s' next in filter expression";
    protected String expected2$str() {
        return expected2;
    }
    @Override
    public final IllegalArgumentException expected(final String trueToken, final String falseToken) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(expected2$str(), trueToken, falseToken));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEnd = "WFLYLOG0076: Unexpected end of filter expression";
    protected String unexpectedEnd$str() {
        return unexpectedEnd;
    }
    @Override
    public final IllegalArgumentException unexpectedEnd() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unexpectedEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extraData = "WFLYLOG0077: Extra data after filter expression";
    protected String extraData$str() {
        return extraData;
    }
    @Override
    public final IllegalArgumentException extraData() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(extraData$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionNotInitialized = "WFLYLOG0078: The logging subsystem requires the log manager to be org.jboss.logmanager.LogManager. The subsystem has not be initialized and cannot be used. To use JBoss Log Manager you must add the system property \"java.util.logging.manager\" and set it to \"org.jboss.logmanager.LogManager\"";
    protected String extensionNotInitialized$str() {
        return extensionNotInitialized;
    }
    @Override
    public final IllegalStateException extensionNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(extensionNotInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReadLogFile = "WFLYLOG0079: Failed to read the log file '%s'";
    protected String failedToReadLogFile$str() {
        return failedToReadLogFile;
    }
    @Override
    public final RuntimeException failedToReadLogFile(final Throwable cause, final String name) {
        final RuntimeException result = new RuntimeException(String.format(failedToReadLogFile$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String logFileNotFound = "WFLYLOG0080: File '%s' was not found and cannot be found in the %s directory.";
    protected String logFileNotFound$str() {
        return logFileNotFound;
    }
    @Override
    public final NoSuchResourceException logFileNotFound(final String name, final String directoryProperty) {
        final NoSuchResourceException result = new NoSuchResourceException(String.format(logFileNotFound$str(), name, directoryProperty));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readNotAllowed = "WFLYLOG0081: File '%s' is not allowed to be read.";
    protected String readNotAllowed$str() {
        return readNotAllowed;
    }
    @Override
    public final OperationFailedException readNotAllowed(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(readNotAllowed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String suffixContainsMillis = "WFLYLOG0082: The suffix (%s) can not contain seconds or milliseconds.";
    protected String suffixContainsMillis$str() {
        return suffixContainsMillis;
    }
    @Override
    public final String suffixContainsMillis(final String suffix) {
        return String.format(suffixContainsMillis$str(), suffix);
    }
    private static final String invalidLogFile = "WFLYLOG0083: Path '%s' is a directory and cannot be used as a log file.";
    protected String invalidLogFile$str() {
        return invalidLogFile;
    }
    @Override
    public final OperationFailedException invalidLogFile(final String path) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidLogFile$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRegisterResourceOfType = "WFLYLOG0084: Resources of type %s cannot be registered";
    protected String cannotRegisterResourceOfType$str() {
        return cannotRegisterResourceOfType;
    }
    @Override
    public final UnsupportedOperationException cannotRegisterResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(cannotRegisterResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveResourceOfType = "WFLYLOG0085: Resources of type %s cannot be removed";
    protected String cannotRemoveResourceOfType$str() {
        return cannotRemoveResourceOfType;
    }
    @Override
    public final UnsupportedOperationException cannotRemoveResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(cannotRemoveResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentNameNotFound = "WFLYLOG0086: Could not determine deployment name from the address %s.";
    protected String deploymentNameNotFound$str() {
        return deploymentNameNotFound;
    }
    @Override
    public final IllegalArgumentException deploymentNameNotFound(final PathAddress address) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(deploymentNameNotFound$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorProcessingLogDirectory(final String logDir) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, null, errorProcessingLogDirectory$str(), logDir);
    }
    private static final String errorProcessingLogDirectory = "WFLYLOG0087: Failed to process logging directory %s. Log files cannot be listed.";
    protected String errorProcessingLogDirectory$str() {
        return errorProcessingLogDirectory;
    }
    @Override
    public final void errorDeterminingChildrenExist(final Throwable cause, final String childType) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, errorDeterminingChildrenExist$str(), childType);
    }
    private static final String errorDeterminingChildrenExist = "WFLYLOG0088: Could not determine %s had any children resources.";
    protected String errorDeterminingChildrenExist$str() {
        return errorDeterminingChildrenExist;
    }
    @Override
    public final void unresolvablePathExpressions(final Set<String> unresolvableExpressions) {
        if (super.log.isEnabled(org.jboss.logging.Logger.Level.WARN) && unresolvablePathExpressions_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, unresolvablePathExpressions$str(), unresolvableExpressions);
        }
    }
    private static final String unresolvablePathExpressions = "WFLYLOG0090: The following path expressions could not be resolved while attempting to determine which log files are available to be read: %s";
    protected String unresolvablePathExpressions$str() {
        return unresolvablePathExpressions;
    }
    private static final AtomicBoolean unresolvablePathExpressions_$Once = new AtomicBoolean(false);
}
