package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Keycloak;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface KeycloakConsumer<T extends Keycloak<T>> {

	/**
	 * Configure a pre-constructed instance of Keycloak resource
	 * 
	 * @parameter Instance of Keycloak to configure
	 * @return nothing
	 */
	void accept(T value);

	default KeycloakConsumer<T> andThen(KeycloakConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}