package org.wildfly.swarm.config.keycloak;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A Keycloak realm.
 */
@Address("/subsystem=keycloak/realm=*")
@ResourceType("realm")
public class Realm<T extends Realm<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("SSL Setting")
	private Boolean allowAnyHostname;
	@AttributeDocumentation("Refresh token on every single web request")
	private Boolean alwaysRefreshToken;
	@AttributeDocumentation("Base URL of the Realm Auth Server")
	private String authServerUrl;
	@AttributeDocumentation("URL to use to make background calls to auth server")
	private String authServerUrlForBackendRequests;
	@AttributeDocumentation("n/a")
	private String clientKeyPassword;
	@AttributeDocumentation("n/a")
	private String clientKeystore;
	@AttributeDocumentation("n/a")
	private String clientKeystorePassword;
	@AttributeDocumentation("Connection pool size for the client used by the adapter")
	private Integer connectionPoolSize;
	@AttributeDocumentation("CORS allowed headers")
	private String corsAllowedHeaders;
	@AttributeDocumentation("CORS allowed methods")
	private String corsAllowedMethods;
	@AttributeDocumentation("CORS max-age header")
	private Integer corsMaxAge;
	@AttributeDocumentation("Adapter will not use a trust manager when making adapter HTTPS requests")
	private Boolean disableTrustManager;
	@AttributeDocumentation("Enable Keycloak CORS support")
	private Boolean enableCors;
	@AttributeDocumentation("Enable secure URL that exposes access token")
	private Boolean exposeToken;
	@AttributeDocumentation("token attribute to use to set Principal name")
	private String principalAttribute;
	@AttributeDocumentation("Public key of the realm")
	private String realmPublicKey;
	@AttributeDocumentation("Cluster setting")
	private Boolean registerNodeAtStartup;
	@AttributeDocumentation("how often to re-register node")
	private Integer registerNodePeriod;
	@AttributeDocumentation("Specify if SSL is required (valid values are all, external and none)")
	private String sslRequired;
	@AttributeDocumentation("cookie or session storage for auth session data")
	private String tokenStore;
	@AttributeDocumentation("Truststore used for adapter client HTTPS requests")
	private String truststore;
	@AttributeDocumentation("Password of the Truststore")
	private String truststorePassword;

	public Realm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * SSL Setting
	 */
	@ModelNodeBinding(detypedName = "allow-any-hostname")
	public Boolean allowAnyHostname() {
		return this.allowAnyHostname;
	}

	/**
	 * SSL Setting
	 */
	@SuppressWarnings("unchecked")
	public T allowAnyHostname(java.lang.Boolean value) {
		Object oldValue = this.allowAnyHostname;
		this.allowAnyHostname = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowAnyHostname", oldValue, value);
		return (T) this;
	}

	/**
	 * Refresh token on every single web request
	 */
	@ModelNodeBinding(detypedName = "always-refresh-token")
	public Boolean alwaysRefreshToken() {
		return this.alwaysRefreshToken;
	}

	/**
	 * Refresh token on every single web request
	 */
	@SuppressWarnings("unchecked")
	public T alwaysRefreshToken(java.lang.Boolean value) {
		Object oldValue = this.alwaysRefreshToken;
		this.alwaysRefreshToken = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("alwaysRefreshToken", oldValue, value);
		return (T) this;
	}

	/**
	 * Base URL of the Realm Auth Server
	 */
	@ModelNodeBinding(detypedName = "auth-server-url")
	public String authServerUrl() {
		return this.authServerUrl;
	}

	/**
	 * Base URL of the Realm Auth Server
	 */
	@SuppressWarnings("unchecked")
	public T authServerUrl(java.lang.String value) {
		Object oldValue = this.authServerUrl;
		this.authServerUrl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authServerUrl", oldValue, value);
		return (T) this;
	}

	/**
	 * URL to use to make background calls to auth server
	 */
	@ModelNodeBinding(detypedName = "auth-server-url-for-backend-requests")
	public String authServerUrlForBackendRequests() {
		return this.authServerUrlForBackendRequests;
	}

	/**
	 * URL to use to make background calls to auth server
	 */
	@SuppressWarnings("unchecked")
	public T authServerUrlForBackendRequests(java.lang.String value) {
		Object oldValue = this.authServerUrlForBackendRequests;
		this.authServerUrlForBackendRequests = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authServerUrlForBackendRequests",
					oldValue, value);
		return (T) this;
	}

	/**
	 * n/a
	 */
	@ModelNodeBinding(detypedName = "client-key-password")
	public String clientKeyPassword() {
		return this.clientKeyPassword;
	}

	/**
	 * n/a
	 */
	@SuppressWarnings("unchecked")
	public T clientKeyPassword(java.lang.String value) {
		Object oldValue = this.clientKeyPassword;
		this.clientKeyPassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientKeyPassword", oldValue, value);
		return (T) this;
	}

	/**
	 * n/a
	 */
	@ModelNodeBinding(detypedName = "client-keystore")
	public String clientKeystore() {
		return this.clientKeystore;
	}

	/**
	 * n/a
	 */
	@SuppressWarnings("unchecked")
	public T clientKeystore(java.lang.String value) {
		Object oldValue = this.clientKeystore;
		this.clientKeystore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientKeystore", oldValue, value);
		return (T) this;
	}

	/**
	 * n/a
	 */
	@ModelNodeBinding(detypedName = "client-keystore-password")
	public String clientKeystorePassword() {
		return this.clientKeystorePassword;
	}

	/**
	 * n/a
	 */
	@SuppressWarnings("unchecked")
	public T clientKeystorePassword(java.lang.String value) {
		Object oldValue = this.clientKeystorePassword;
		this.clientKeystorePassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientKeystorePassword", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Connection pool size for the client used by the adapter
	 */
	@ModelNodeBinding(detypedName = "connection-pool-size")
	public Integer connectionPoolSize() {
		return this.connectionPoolSize;
	}

	/**
	 * Connection pool size for the client used by the adapter
	 */
	@SuppressWarnings("unchecked")
	public T connectionPoolSize(java.lang.Integer value) {
		Object oldValue = this.connectionPoolSize;
		this.connectionPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * CORS allowed headers
	 */
	@ModelNodeBinding(detypedName = "cors-allowed-headers")
	public String corsAllowedHeaders() {
		return this.corsAllowedHeaders;
	}

	/**
	 * CORS allowed headers
	 */
	@SuppressWarnings("unchecked")
	public T corsAllowedHeaders(java.lang.String value) {
		Object oldValue = this.corsAllowedHeaders;
		this.corsAllowedHeaders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("corsAllowedHeaders", oldValue, value);
		return (T) this;
	}

	/**
	 * CORS allowed methods
	 */
	@ModelNodeBinding(detypedName = "cors-allowed-methods")
	public String corsAllowedMethods() {
		return this.corsAllowedMethods;
	}

	/**
	 * CORS allowed methods
	 */
	@SuppressWarnings("unchecked")
	public T corsAllowedMethods(java.lang.String value) {
		Object oldValue = this.corsAllowedMethods;
		this.corsAllowedMethods = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("corsAllowedMethods", oldValue, value);
		return (T) this;
	}

	/**
	 * CORS max-age header
	 */
	@ModelNodeBinding(detypedName = "cors-max-age")
	public Integer corsMaxAge() {
		return this.corsMaxAge;
	}

	/**
	 * CORS max-age header
	 */
	@SuppressWarnings("unchecked")
	public T corsMaxAge(java.lang.Integer value) {
		Object oldValue = this.corsMaxAge;
		this.corsMaxAge = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("corsMaxAge", oldValue, value);
		return (T) this;
	}

	/**
	 * Adapter will not use a trust manager when making adapter HTTPS requests
	 */
	@ModelNodeBinding(detypedName = "disable-trust-manager")
	public Boolean disableTrustManager() {
		return this.disableTrustManager;
	}

	/**
	 * Adapter will not use a trust manager when making adapter HTTPS requests
	 */
	@SuppressWarnings("unchecked")
	public T disableTrustManager(java.lang.Boolean value) {
		Object oldValue = this.disableTrustManager;
		this.disableTrustManager = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("disableTrustManager", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable Keycloak CORS support
	 */
	@ModelNodeBinding(detypedName = "enable-cors")
	public Boolean enableCors() {
		return this.enableCors;
	}

	/**
	 * Enable Keycloak CORS support
	 */
	@SuppressWarnings("unchecked")
	public T enableCors(java.lang.Boolean value) {
		Object oldValue = this.enableCors;
		this.enableCors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableCors", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable secure URL that exposes access token
	 */
	@ModelNodeBinding(detypedName = "expose-token")
	public Boolean exposeToken() {
		return this.exposeToken;
	}

	/**
	 * Enable secure URL that exposes access token
	 */
	@SuppressWarnings("unchecked")
	public T exposeToken(java.lang.Boolean value) {
		Object oldValue = this.exposeToken;
		this.exposeToken = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("exposeToken", oldValue, value);
		return (T) this;
	}

	/**
	 * token attribute to use to set Principal name
	 */
	@ModelNodeBinding(detypedName = "principal-attribute")
	public String principalAttribute() {
		return this.principalAttribute;
	}

	/**
	 * token attribute to use to set Principal name
	 */
	@SuppressWarnings("unchecked")
	public T principalAttribute(java.lang.String value) {
		Object oldValue = this.principalAttribute;
		this.principalAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principalAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * Public key of the realm
	 */
	@ModelNodeBinding(detypedName = "realm-public-key")
	public String realmPublicKey() {
		return this.realmPublicKey;
	}

	/**
	 * Public key of the realm
	 */
	@SuppressWarnings("unchecked")
	public T realmPublicKey(java.lang.String value) {
		Object oldValue = this.realmPublicKey;
		this.realmPublicKey = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realmPublicKey", oldValue, value);
		return (T) this;
	}

	/**
	 * Cluster setting
	 */
	@ModelNodeBinding(detypedName = "register-node-at-startup")
	public Boolean registerNodeAtStartup() {
		return this.registerNodeAtStartup;
	}

	/**
	 * Cluster setting
	 */
	@SuppressWarnings("unchecked")
	public T registerNodeAtStartup(java.lang.Boolean value) {
		Object oldValue = this.registerNodeAtStartup;
		this.registerNodeAtStartup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("registerNodeAtStartup", oldValue,
					value);
		return (T) this;
	}

	/**
	 * how often to re-register node
	 */
	@ModelNodeBinding(detypedName = "register-node-period")
	public Integer registerNodePeriod() {
		return this.registerNodePeriod;
	}

	/**
	 * how often to re-register node
	 */
	@SuppressWarnings("unchecked")
	public T registerNodePeriod(java.lang.Integer value) {
		Object oldValue = this.registerNodePeriod;
		this.registerNodePeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("registerNodePeriod", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify if SSL is required (valid values are all, external and none)
	 */
	@ModelNodeBinding(detypedName = "ssl-required")
	public String sslRequired() {
		return this.sslRequired;
	}

	/**
	 * Specify if SSL is required (valid values are all, external and none)
	 */
	@SuppressWarnings("unchecked")
	public T sslRequired(java.lang.String value) {
		Object oldValue = this.sslRequired;
		this.sslRequired = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sslRequired", oldValue, value);
		return (T) this;
	}

	/**
	 * cookie or session storage for auth session data
	 */
	@ModelNodeBinding(detypedName = "token-store")
	public String tokenStore() {
		return this.tokenStore;
	}

	/**
	 * cookie or session storage for auth session data
	 */
	@SuppressWarnings("unchecked")
	public T tokenStore(java.lang.String value) {
		Object oldValue = this.tokenStore;
		this.tokenStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tokenStore", oldValue, value);
		return (T) this;
	}

	/**
	 * Truststore used for adapter client HTTPS requests
	 */
	@ModelNodeBinding(detypedName = "truststore")
	public String truststore() {
		return this.truststore;
	}

	/**
	 * Truststore used for adapter client HTTPS requests
	 */
	@SuppressWarnings("unchecked")
	public T truststore(java.lang.String value) {
		Object oldValue = this.truststore;
		this.truststore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("truststore", oldValue, value);
		return (T) this;
	}

	/**
	 * Password of the Truststore
	 */
	@ModelNodeBinding(detypedName = "truststore-password")
	public String truststorePassword() {
		return this.truststorePassword;
	}

	/**
	 * Password of the Truststore
	 */
	@SuppressWarnings("unchecked")
	public T truststorePassword(java.lang.String value) {
		Object oldValue = this.truststorePassword;
		this.truststorePassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("truststorePassword", oldValue, value);
		return (T) this;
	}
}