package org.jboss.shrinkwrap.descriptor.impl.jsptaglibrary21; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jsptaglibrary21.TldExtensionType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> tld-extensionType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @author <a href="mailto:ggastald@redhat.com">George Gastaldi</a>
 */
public class TldExtensionTypeImpl<T> implements Child<T>, TldExtensionType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public TldExtensionTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public TldExtensionTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: TldExtensionType ElementName: javaee:extensibleType ElementType : extension-element
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>extension-element</code> element 
    * @return the current instance of <code>TldExtensionType<T></code> 
    */
   public TldExtensionType<T> extensionElement()
   {
      childNode.getOrCreate("extension-element");
      return this;
   }

   /**
    * Removes the <code>extension-element</code> element 
    * @return the current instance of <code>TldExtensionType<T></code> 
    */
   public Boolean isExtensionElement()
   {
      return childNode.getSingle("extension-element") != null;
   }

   /**
    * Removes the <code>extension-element</code> element 
    * @return the current instance of <code>TldExtensionType<T></code> 
    */
   public TldExtensionType<T> removeExtensionElement()
   {
      childNode.removeChild("extension-element");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: TldExtensionType ElementName: xsd:anyURI ElementType : namespace
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>namespace</code> attribute
    * @param namespace the value for the attribute <code>namespace</code> 
    * @return the current instance of <code>TldExtensionType<T></code> 
    */
   public TldExtensionType<T> namespace(String namespace)
   {
      childNode.attribute("namespace", namespace);
      return this;
   }

   /**
    * Returns the <code>namespace</code> attribute
    * @return the value defined for the attribute <code>namespace</code> 
    */
      public String getNamespace()
   {
      return childNode.getAttribute("namespace");
   }

   /**
    * Removes the <code>namespace</code> attribute 
    * @return the current instance of <code>TldExtensionType<T></code> 
    */
   public TldExtensionType<T> removeNamespace()
   {
      childNode.removeAttribute("namespace");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: TldExtensionType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>TldExtensionType<T></code> 
    */
   public TldExtensionType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>TldExtensionType<T></code> 
    */
   public TldExtensionType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
