package org.jboss.shrinkwrap.descriptor.api.beans11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.beans.*;
import org.jboss.shrinkwrap.descriptor.api.beans.JavaeeDecoratorsCommType;
/**
 * This interface defines the contract for the <code> decorators </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface Decorators<T> extends Child<T>, 
    JavaeeDecoratorsCommType<T, Decorators<T>> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: Decorators ElementName: xsd:string ElementType : class
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>class</code> elements, 
    * a new <code>class</code> element 
    * @param values list of <code>class</code> objects 
    * @return the current instance of <code>Decorators<T></code> 
    */
   public Decorators<T> clazz(String ... values);

   /**
    * Returns all <code>class</code> elements
    * @return list of <code>class</code> 
    */
   public List<String> getAllClazz();

   /**
    * Removes the <code>class</code> element 
    * @return the current instance of <code>Decorators<T></code> 
    */
   public Decorators<T> removeAllClazz();
}
