package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Modcluster;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ModclusterConsumer<T extends Modcluster<T>> {

	/**
	 * Configure a pre-constructed instance of Modcluster resource
	 * 
	 * @parameter Instance of Modcluster to configure
	 * @return nothing
	 */
	void accept(T value);

	default ModclusterConsumer<T> andThen(ModclusterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}