package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.ejb3.FilePassivationStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface FilePassivationStoreConsumer<T extends FilePassivationStore<T>> {

	/**
	 * Configure a pre-constructed instance of FilePassivationStore resource
	 * 
	 * @parameter Instance of FilePassivationStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default FilePassivationStoreConsumer<T> andThen(
			FilePassivationStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}