package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.ListenerThreadPool;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ListenerThreadPoolConsumer<T extends ListenerThreadPool<T>> {

	/**
	 * Configure a pre-constructed instance of ListenerThreadPool resource
	 * 
	 * @parameter Instance of ListenerThreadPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default ListenerThreadPoolConsumer<T> andThen(
			ListenerThreadPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}