package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration of whether vault expressions should be considered sensitive.
 */
@Address("/core-service=management/access=authorization/constraint=vault-expression")
@ResourceType("constraint")
@Implicit
public class VaultExpressionConstraint<T extends VaultExpressionConstraint<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Set to override the default as to whether reading attributes containing vault expressions should be considered sensitive.")
	private Boolean configuredRequiresRead;
	@AttributeDocumentation("Set to override the default as to whether writing attributes containing vault expressions should be considered sensitive.")
	private Boolean configuredRequiresWrite;
	@AttributeDocumentation("Whether reading attributes containing vault expressions should be considered sensitive.")
	private Boolean defaultRequiresRead;
	@AttributeDocumentation("Whether writing attributes containing vault expressions should be considered sensitive.")
	private Boolean defaultRequiresWrite;

	public VaultExpressionConstraint() {
		super();
		this.key = "vault-expression";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Set to override the default as to whether reading attributes containing
	 * vault expressions should be considered sensitive.
	 */
	@ModelNodeBinding(detypedName = "configured-requires-read")
	public Boolean configuredRequiresRead() {
		return this.configuredRequiresRead;
	}

	/**
	 * Set to override the default as to whether reading attributes containing
	 * vault expressions should be considered sensitive.
	 */
	@SuppressWarnings("unchecked")
	public T configuredRequiresRead(java.lang.Boolean value) {
		Object oldValue = this.configuredRequiresRead;
		this.configuredRequiresRead = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("configuredRequiresRead", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Set to override the default as to whether writing attributes containing
	 * vault expressions should be considered sensitive.
	 */
	@ModelNodeBinding(detypedName = "configured-requires-write")
	public Boolean configuredRequiresWrite() {
		return this.configuredRequiresWrite;
	}

	/**
	 * Set to override the default as to whether writing attributes containing
	 * vault expressions should be considered sensitive.
	 */
	@SuppressWarnings("unchecked")
	public T configuredRequiresWrite(java.lang.Boolean value) {
		Object oldValue = this.configuredRequiresWrite;
		this.configuredRequiresWrite = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("configuredRequiresWrite", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Whether reading attributes containing vault expressions should be
	 * considered sensitive.
	 */
	@ModelNodeBinding(detypedName = "default-requires-read")
	public Boolean defaultRequiresRead() {
		return this.defaultRequiresRead;
	}

	/**
	 * Whether reading attributes containing vault expressions should be
	 * considered sensitive.
	 */
	@SuppressWarnings("unchecked")
	public T defaultRequiresRead(java.lang.Boolean value) {
		Object oldValue = this.defaultRequiresRead;
		this.defaultRequiresRead = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultRequiresRead", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether writing attributes containing vault expressions should be
	 * considered sensitive.
	 */
	@ModelNodeBinding(detypedName = "default-requires-write")
	public Boolean defaultRequiresWrite() {
		return this.defaultRequiresWrite;
	}

	/**
	 * Whether writing attributes containing vault expressions should be
	 * considered sensitive.
	 */
	@SuppressWarnings("unchecked")
	public T defaultRequiresWrite(java.lang.Boolean value) {
		Object oldValue = this.defaultRequiresWrite;
		this.defaultRequiresWrite = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultRequiresWrite", oldValue, value);
		return (T) this;
	}
}