package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.JaasAuthentication;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JaasAuthenticationConsumer<T extends JaasAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of JaasAuthentication resource
	 * 
	 * @parameter Instance of JaasAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default JaasAuthenticationConsumer<T> andThen(
			JaasAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}