package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.KerberosServerIdentity;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface KerberosServerIdentityConsumer<T extends KerberosServerIdentity<T>> {

	/**
	 * Configure a pre-constructed instance of KerberosServerIdentity resource
	 * 
	 * @parameter Instance of KerberosServerIdentity to configure
	 * @return nothing
	 */
	void accept(T value);

	default KerberosServerIdentityConsumer<T> andThen(
			KerberosServerIdentityConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}