package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandler;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface GroupingHandlerConsumer<T extends GroupingHandler<T>> {

	/**
	 * Configure a pre-constructed instance of GroupingHandler resource
	 * 
	 * @parameter Instance of GroupingHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default GroupingHandlerConsumer<T> andThen(GroupingHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}