package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LegacyConnectionFactoryConsumer<T extends LegacyConnectionFactory<T>> {

	/**
	 * Configure a pre-constructed instance of LegacyConnectionFactory resource
	 * 
	 * @parameter Instance of LegacyConnectionFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default LegacyConnectionFactoryConsumer<T> andThen(
			LegacyConnectionFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}