package org.wildfly.swarm.config.modcluster.mod_cluster_config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The SSL configuration to client MCMP logic.
 */
@Address("/subsystem=modcluster/mod-cluster-config=configuration/ssl=configuration")
@ResourceType("ssl")
@Implicit
public class ConfigurationSsl<T extends ConfigurationSsl<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Certificate authority.")
	private String caCertificateFile;
	@AttributeDocumentation("Certificate authority revocation list.")
	private String caRevocationUrl;
	@AttributeDocumentation("Key file for the certificate.")
	private String certificateKeyFile;
	@AttributeDocumentation("The allowed cipher suite.")
	private String cipherSuite;
	@AttributeDocumentation("The key alias.")
	private String keyAlias;
	@AttributeDocumentation("Password.")
	private String password;
	@AttributeDocumentation("The SSL protocols that are enabled.")
	private String protocol;

	public ConfigurationSsl() {
		super();
		this.key = "configuration";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Certificate authority.
	 */
	@ModelNodeBinding(detypedName = "ca-certificate-file")
	public String caCertificateFile() {
		return this.caCertificateFile;
	}

	/**
	 * Certificate authority.
	 */
	@SuppressWarnings("unchecked")
	public T caCertificateFile(java.lang.String value) {
		Object oldValue = this.caCertificateFile;
		this.caCertificateFile = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("caCertificateFile", oldValue, value);
		return (T) this;
	}

	/**
	 * Certificate authority revocation list.
	 */
	@ModelNodeBinding(detypedName = "ca-revocation-url")
	public String caRevocationUrl() {
		return this.caRevocationUrl;
	}

	/**
	 * Certificate authority revocation list.
	 */
	@SuppressWarnings("unchecked")
	public T caRevocationUrl(java.lang.String value) {
		Object oldValue = this.caRevocationUrl;
		this.caRevocationUrl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("caRevocationUrl", oldValue, value);
		return (T) this;
	}

	/**
	 * Key file for the certificate.
	 */
	@ModelNodeBinding(detypedName = "certificate-key-file")
	public String certificateKeyFile() {
		return this.certificateKeyFile;
	}

	/**
	 * Key file for the certificate.
	 */
	@SuppressWarnings("unchecked")
	public T certificateKeyFile(java.lang.String value) {
		Object oldValue = this.certificateKeyFile;
		this.certificateKeyFile = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("certificateKeyFile", oldValue, value);
		return (T) this;
	}

	/**
	 * The allowed cipher suite.
	 */
	@ModelNodeBinding(detypedName = "cipher-suite")
	public String cipherSuite() {
		return this.cipherSuite;
	}

	/**
	 * The allowed cipher suite.
	 */
	@SuppressWarnings("unchecked")
	public T cipherSuite(java.lang.String value) {
		Object oldValue = this.cipherSuite;
		this.cipherSuite = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cipherSuite", oldValue, value);
		return (T) this;
	}

	/**
	 * The key alias.
	 */
	@ModelNodeBinding(detypedName = "key-alias")
	public String keyAlias() {
		return this.keyAlias;
	}

	/**
	 * The key alias.
	 */
	@SuppressWarnings("unchecked")
	public T keyAlias(java.lang.String value) {
		Object oldValue = this.keyAlias;
		this.keyAlias = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyAlias", oldValue, value);
		return (T) this;
	}

	/**
	 * Password.
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * Password.
	 */
	@SuppressWarnings("unchecked")
	public T password(java.lang.String value) {
		Object oldValue = this.password;
		this.password = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("password", oldValue, value);
		return (T) this;
	}

	/**
	 * The SSL protocols that are enabled.
	 */
	@ModelNodeBinding(detypedName = "protocol")
	public String protocol() {
		return this.protocol;
	}

	/**
	 * The SSL protocols that are enabled.
	 */
	@SuppressWarnings("unchecked")
	public T protocol(java.lang.String value) {
		Object oldValue = this.protocol;
		this.protocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocol", oldValue, value);
		return (T) this;
	}
}