package org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider;

import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.LoadMetric;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LoadMetricConsumer<T extends LoadMetric<T>> {

	/**
	 * Configure a pre-constructed instance of LoadMetric resource
	 * 
	 * @parameter Instance of LoadMetric to configure
	 * @return nothing
	 */
	void accept(T value);

	default LoadMetricConsumer<T> andThen(LoadMetricConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}