package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Custom filter
 */
@Address("/subsystem=undertow/configuration=filter/custom-filter=*")
@ResourceType("custom-filter")
public class CustomFilter<T extends CustomFilter<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Class name of HttpHandler")
	private String className;
	@AttributeDocumentation("Module name where class can be loaded from")
	private String module;
	@AttributeDocumentation("Filter parameters")
	private Map parameters;

	public CustomFilter(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class name of HttpHandler
	 */
	@ModelNodeBinding(detypedName = "class-name")
	public String className() {
		return this.className;
	}

	/**
	 * Class name of HttpHandler
	 */
	@SuppressWarnings("unchecked")
	public T className(java.lang.String value) {
		Object oldValue = this.className;
		this.className = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("className", oldValue, value);
		return (T) this;
	}

	/**
	 * Module name where class can be loaded from
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Module name where class can be loaded from
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * Filter parameters
	 */
	@ModelNodeBinding(detypedName = "parameters")
	public Map parameters() {
		return this.parameters;
	}

	/**
	 * Filter parameters
	 */
	@SuppressWarnings("unchecked")
	public T parameters(java.util.Map value) {
		Object oldValue = this.parameters;
		this.parameters = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("parameters", oldValue, value);
		return (T) this;
	}

	/**
	 * Filter parameters
	 */
	@SuppressWarnings("unchecked")
	public T parameter(java.lang.String key, java.lang.Object value) {
		if (this.parameters == null) {
			this.parameters = new java.util.HashMap<>();
		}
		this.parameters.put(key, value);
		return (T) this;
	}
}