package org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer;

import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LoadBalancingGroupConsumer<T extends LoadBalancingGroup<T>> {

	/**
	 * Configure a pre-constructed instance of LoadBalancingGroup resource
	 * 
	 * @parameter Instance of LoadBalancingGroup to configure
	 * @return nothing
	 */
	void accept(T value);

	default LoadBalancingGroupConsumer<T> andThen(
			LoadBalancingGroupConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}