package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> cluster-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ClusterConfigType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeAllDescription();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: javaee:string ElementType : partition-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>partition-name</code> element
    * @param partitionName the value for the element <code>partition-name</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> partitionName(String partitionName);

   /**
    * Returns the <code>partition-name</code> element
    * @return the node defined for the element <code>partition-name</code> 
    */
   public String getPartitionName();

   /**
    * Removes the <code>partition-name</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removePartitionName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: javaee:string ElementType : home-load-balance-policy
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>home-load-balance-policy</code> element
    * @param homeLoadBalancePolicy the value for the element <code>home-load-balance-policy</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> homeLoadBalancePolicy(String homeLoadBalancePolicy);

   /**
    * Returns the <code>home-load-balance-policy</code> element
    * @return the node defined for the element <code>home-load-balance-policy</code> 
    */
   public String getHomeLoadBalancePolicy();

   /**
    * Removes the <code>home-load-balance-policy</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeHomeLoadBalancePolicy();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: javaee:string ElementType : bean-load-balance-policy
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>bean-load-balance-policy</code> element
    * @param beanLoadBalancePolicy the value for the element <code>bean-load-balance-policy</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> beanLoadBalancePolicy(String beanLoadBalancePolicy);

   /**
    * Returns the <code>bean-load-balance-policy</code> element
    * @return the node defined for the element <code>bean-load-balance-policy</code> 
    */
   public String getBeanLoadBalancePolicy();

   /**
    * Removes the <code>bean-load-balance-policy</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeBeanLoadBalancePolicy();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: javaee:string ElementType : load-balance-policy
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>load-balance-policy</code> element
    * @param loadBalancePolicy the value for the element <code>load-balance-policy</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> loadBalancePolicy(String loadBalancePolicy);

   /**
    * Returns the <code>load-balance-policy</code> element
    * @return the node defined for the element <code>load-balance-policy</code> 
    */
   public String getLoadBalancePolicy();

   /**
    * Removes the <code>load-balance-policy</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeLoadBalancePolicy();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: xsd:token ElementType : session-state-manager-jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>session-state-manager-jndi-name</code> element
    * @param sessionStateManagerJndiName the value for the element <code>session-state-manager-jndi-name</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> sessionStateManagerJndiName(String sessionStateManagerJndiName);

   /**
    * Returns the <code>session-state-manager-jndi-name</code> element
    * @return the node defined for the element <code>session-state-manager-jndi-name</code> 
    */
   public String getSessionStateManagerJndiName();

   /**
    * Removes the <code>session-state-manager-jndi-name</code> element 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeSessionStateManagerJndiName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClusterConfigType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ClusterConfigType<T></code> 
    */
   public ClusterConfigType<T> removeId();
}
