package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.WebserviceDescriptionType;
/**
 * This interface defines the contract for the <code> webservicesType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface WebservicesType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebservicesType ElementName: xsd:token ElementType : context-root
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>context-root</code> element
    * @param contextRoot the value for the element <code>context-root</code> 
    * @return the current instance of <code>WebservicesType<T></code> 
    */
   public WebservicesType<T> contextRoot(String contextRoot);

   /**
    * Returns the <code>context-root</code> element
    * @return the node defined for the element <code>context-root</code> 
    */
   public String getContextRoot();

   /**
    * Removes the <code>context-root</code> element 
    * @return the current instance of <code>WebservicesType<T></code> 
    */
   public WebservicesType<T> removeContextRoot();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebservicesType ElementName: jboss:webservice-descriptionType ElementType : webservice-description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>webservice-description</code> element will be created and returned.
    * Otherwise, the first existing <code>webservice-description</code> element will be returned.
    * @return the instance defined for the element <code>webservice-description</code> 
    */
   public WebserviceDescriptionType<WebservicesType<T>> getOrCreateWebserviceDescription();

   /**
    * Creates a new <code>webservice-description</code> element 
    * @return the new created instance of <code>WebserviceDescriptionType<WebservicesType<T>></code> 
    */
   public WebserviceDescriptionType<WebservicesType<T>> createWebserviceDescription();

   /**
    * Returns all <code>webservice-description</code> elements
    * @return list of <code>webservice-description</code> 
    */
   public List<WebserviceDescriptionType<WebservicesType<T>>> getAllWebserviceDescription();

   /**
    * Removes all <code>webservice-description</code> elements 
    * @return the current instance of <code>WebserviceDescriptionType<WebservicesType<T>></code> 
    */
   public WebservicesType<T> removeAllWebserviceDescription();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebservicesType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>WebservicesType<T></code> 
    */
   public WebservicesType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>WebservicesType<T></code> 
    */
   public WebservicesType<T> removeId();
}
