package org.jboss.shrinkwrap.descriptor.api.jbosscommon51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.PortComponentRefType;
/**
 * This interface defines the contract for the <code> service-refType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ServiceRefType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceRefType ElementName: xsd:string ElementType : service-ref-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>service-ref-name</code> element
    * @param serviceRefName the value for the element <code>service-ref-name</code> 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> serviceRefName(String serviceRefName);

   /**
    * Returns the <code>service-ref-name</code> element
    * @return the node defined for the element <code>service-ref-name</code> 
    */
   public String getServiceRefName();

   /**
    * Removes the <code>service-ref-name</code> element 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> removeServiceRefName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceRefType ElementName: xsd:string ElementType : service-impl-class
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>service-impl-class</code> element
    * @param serviceImplClass the value for the element <code>service-impl-class</code> 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> serviceImplClass(String serviceImplClass);

   /**
    * Returns the <code>service-impl-class</code> element
    * @return the node defined for the element <code>service-impl-class</code> 
    */
   public String getServiceImplClass();

   /**
    * Removes the <code>service-impl-class</code> element 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> removeServiceImplClass();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceRefType ElementName: xsd:string ElementType : service-qname
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>service-qname</code> element
    * @param serviceQname the value for the element <code>service-qname</code> 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> serviceQname(String serviceQname);

   /**
    * Returns the <code>service-qname</code> element
    * @return the node defined for the element <code>service-qname</code> 
    */
   public String getServiceQname();

   /**
    * Removes the <code>service-qname</code> element 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> removeServiceQname();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceRefType ElementName: xsd:string ElementType : config-name
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>config-name</code> element
    * @param configName the value for the element <code>config-name</code> 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> configName(String configName);

   /**
    * Returns the <code>config-name</code> element
    * @return the node defined for the element <code>config-name</code> 
    */
   public String getConfigName();

   /**
    * Removes the <code>config-name</code> element 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> removeConfigName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceRefType ElementName: xsd:string ElementType : config-file
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>config-file</code> element
    * @param configFile the value for the element <code>config-file</code> 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> configFile(String configFile);

   /**
    * Returns the <code>config-file</code> element
    * @return the node defined for the element <code>config-file</code> 
    */
   public String getConfigFile();

   /**
    * Removes the <code>config-file</code> element 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> removeConfigFile();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceRefType ElementName: xsd:string ElementType : handler-chain
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>handler-chain</code> element
    * @param handlerChain the value for the element <code>handler-chain</code> 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> handlerChain(String handlerChain);

   /**
    * Returns the <code>handler-chain</code> element
    * @return the node defined for the element <code>handler-chain</code> 
    */
   public String getHandlerChain();

   /**
    * Removes the <code>handler-chain</code> element 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> removeHandlerChain();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceRefType ElementName: jboss:port-component-refType ElementType : port-component-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>port-component-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>port-component-ref</code> element will be returned.
    * @return the instance defined for the element <code>port-component-ref</code> 
    */
   public PortComponentRefType<ServiceRefType<T>> getOrCreatePortComponentRef();

   /**
    * Creates a new <code>port-component-ref</code> element 
    * @return the new created instance of <code>PortComponentRefType<ServiceRefType<T>></code> 
    */
   public PortComponentRefType<ServiceRefType<T>> createPortComponentRef();

   /**
    * Returns all <code>port-component-ref</code> elements
    * @return list of <code>port-component-ref</code> 
    */
   public List<PortComponentRefType<ServiceRefType<T>>> getAllPortComponentRef();

   /**
    * Removes all <code>port-component-ref</code> elements 
    * @return the current instance of <code>PortComponentRefType<ServiceRefType<T>></code> 
    */
   public ServiceRefType<T> removeAllPortComponentRef();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceRefType ElementName: xsd:string ElementType : wsdl-override
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>wsdl-override</code> element
    * @param wsdlOverride the value for the element <code>wsdl-override</code> 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> wsdlOverride(String wsdlOverride);

   /**
    * Returns the <code>wsdl-override</code> element
    * @return the node defined for the element <code>wsdl-override</code> 
    */
   public String getWsdlOverride();

   /**
    * Removes the <code>wsdl-override</code> element 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> removeWsdlOverride();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceRefType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ServiceRefType<T></code> 
    */
   public ServiceRefType<T> removeId();
}
