package org.jboss.shrinkwrap.descriptor.api.jbossdeployment12; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.TransformerType;
/**
 * This interface defines the contract for the <code> transformerSetType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface TransformerSetType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: TransformerSetType ElementName: jboss:transformerType ElementType : transformer
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>transformer</code> element will be created and returned.
    * Otherwise, the first existing <code>transformer</code> element will be returned.
    * @return the instance defined for the element <code>transformer</code> 
    */
   public TransformerType<TransformerSetType<T>> getOrCreateTransformer();

   /**
    * Creates a new <code>transformer</code> element 
    * @return the new created instance of <code>TransformerType<TransformerSetType<T>></code> 
    */
   public TransformerType<TransformerSetType<T>> createTransformer();

   /**
    * Returns all <code>transformer</code> elements
    * @return list of <code>transformer</code> 
    */
   public List<TransformerType<TransformerSetType<T>>> getAllTransformer();

   /**
    * Removes all <code>transformer</code> elements 
    * @return the current instance of <code>TransformerType<TransformerSetType<T>></code> 
    */
   public TransformerSetType<T> removeAllTransformer();
}
