package org.jboss.shrinkwrap.descriptor.api.jbossmodule13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PathSpecType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PathSpecType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PathSetType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PathSetType;
/**
 * This interface defines the contract for the <code> filterType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface FilterType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: jboss:pathSpecType ElementType : include
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>include</code> element will be created and returned.
    * Otherwise, the first existing <code>include</code> element will be returned.
    * @return the instance defined for the element <code>include</code> 
    */
   public PathSpecType<FilterType<T>> getOrCreateInclude();

   /**
    * Creates a new <code>include</code> element 
    * @return the new created instance of <code>PathSpecType<FilterType<T>></code> 
    */
   public PathSpecType<FilterType<T>> createInclude();

   /**
    * Returns all <code>include</code> elements
    * @return list of <code>include</code> 
    */
   public List<PathSpecType<FilterType<T>>> getAllInclude();

   /**
    * Removes all <code>include</code> elements 
    * @return the current instance of <code>PathSpecType<FilterType<T>></code> 
    */
   public FilterType<T> removeAllInclude();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: jboss:pathSpecType ElementType : exclude
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclude</code> element will be created and returned.
    * Otherwise, the first existing <code>exclude</code> element will be returned.
    * @return the instance defined for the element <code>exclude</code> 
    */
   public PathSpecType<FilterType<T>> getOrCreateExclude();

   /**
    * Creates a new <code>exclude</code> element 
    * @return the new created instance of <code>PathSpecType<FilterType<T>></code> 
    */
   public PathSpecType<FilterType<T>> createExclude();

   /**
    * Returns all <code>exclude</code> elements
    * @return list of <code>exclude</code> 
    */
   public List<PathSpecType<FilterType<T>>> getAllExclude();

   /**
    * Removes all <code>exclude</code> elements 
    * @return the current instance of <code>PathSpecType<FilterType<T>></code> 
    */
   public FilterType<T> removeAllExclude();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: jboss:pathSetType ElementType : include-set
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>include-set</code> element will be created and returned.
    * Otherwise, the first existing <code>include-set</code> element will be returned.
    * @return the instance defined for the element <code>include-set</code> 
    */
   public PathSetType<FilterType<T>> getOrCreateIncludeSet();

   /**
    * Creates a new <code>include-set</code> element 
    * @return the new created instance of <code>PathSetType<FilterType<T>></code> 
    */
   public PathSetType<FilterType<T>> createIncludeSet();

   /**
    * Returns all <code>include-set</code> elements
    * @return list of <code>include-set</code> 
    */
   public List<PathSetType<FilterType<T>>> getAllIncludeSet();

   /**
    * Removes all <code>include-set</code> elements 
    * @return the current instance of <code>PathSetType<FilterType<T>></code> 
    */
   public FilterType<T> removeAllIncludeSet();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: jboss:pathSetType ElementType : exclude-set
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclude-set</code> element will be created and returned.
    * Otherwise, the first existing <code>exclude-set</code> element will be returned.
    * @return the instance defined for the element <code>exclude-set</code> 
    */
   public PathSetType<FilterType<T>> getOrCreateExcludeSet();

   /**
    * Creates a new <code>exclude-set</code> element 
    * @return the new created instance of <code>PathSetType<FilterType<T>></code> 
    */
   public PathSetType<FilterType<T>> createExcludeSet();

   /**
    * Returns all <code>exclude-set</code> elements
    * @return list of <code>exclude-set</code> 
    */
   public List<PathSetType<FilterType<T>>> getAllExcludeSet();

   /**
    * Removes all <code>exclude-set</code> elements 
    * @return the current instance of <code>PathSetType<FilterType<T>></code> 
    */
   public FilterType<T> removeAllExcludeSet();
}
