package org.jboss.shrinkwrap.descriptor.api.jbossmodule13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PathSetType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.FilterType;
/**
 * This interface defines the contract for the <code> systemDependencyType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface SystemDependencyType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SystemDependencyType ElementName: jboss:pathSetType ElementType : paths
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>paths</code> element with the given value will be created.
    * Otherwise, the existing <code>paths</code> element will be returned.
    * @return  a new or existing instance of <code>PathSetType<SystemDependencyType<T>></code> 
    */
   public PathSetType<SystemDependencyType<T>> getOrCreatePaths();

   /**
    * Removes the <code>paths</code> element 
    * @return the current instance of <code>SystemDependencyType<T></code> 
    */
   public SystemDependencyType<T> removePaths();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SystemDependencyType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<SystemDependencyType<T>></code> 
    */
   public FilterType<SystemDependencyType<T>> getOrCreateExports();

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>SystemDependencyType<T></code> 
    */
   public SystemDependencyType<T> removeExports();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SystemDependencyType ElementName: xsd:boolean ElementType : export
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>export</code> attribute
    * @param export the value for the attribute <code>export</code> 
    * @return the current instance of <code>SystemDependencyType<T></code> 
    */
   public SystemDependencyType<T> export(Boolean export);

   /**
    * Returns the <code>export</code> attribute
    * @return the value defined for the attribute <code>export</code> 
    */
public Boolean isExport();

   /**
    * Removes the <code>export</code> attribute 
    * @return the current instance of <code>SystemDependencyType<T></code> 
    */
   public SystemDependencyType<T> removeExport();
}
