package org.jboss.shrinkwrap.descriptor.api.jbossmodule15; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.FilterType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.ResourcesType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.ClassNameType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.PropertyListType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.PermissionsType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.FilterType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.ResourcesType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.ClassNameType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.PropertyListType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.PermissionsType;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     ModuleDescriptor descriptor = Descriptors.create(ModuleDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ModuleDescriptor extends Descriptor, DescriptorNamespace<ModuleDescriptor> {

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<ModuleDescriptor></code> 
    */
   public FilterType<ModuleDescriptor> getOrCreateExports();

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeExports();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<ModuleDescriptor></code> 
    */
   public DependenciesType<ModuleDescriptor> getOrCreateDependencies();

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeDependencies();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<ModuleDescriptor></code> 
    */
   public ResourcesType<ModuleDescriptor> getOrCreateResources();

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeResources();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:classNameType ElementType : main-class
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>main-class</code> element with the given value will be created.
    * Otherwise, the existing <code>main-class</code> element will be returned.
    * @return  a new or existing instance of <code>ClassNameType<ModuleDescriptor></code> 
    */
   public ClassNameType<ModuleDescriptor> getOrCreateMainClass();

   /**
    * Removes the <code>main-class</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeMainClass();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:propertyListType ElementType : properties
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>properties</code> element with the given value will be created.
    * Otherwise, the existing <code>properties</code> element will be returned.
    * @return  a new or existing instance of <code>PropertyListType<ModuleDescriptor></code> 
    */
   public PropertyListType<ModuleDescriptor> getOrCreateProperties();

   /**
    * Removes the <code>properties</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeProperties();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:permissionsType ElementType : permissions
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>permissions</code> element with the given value will be created.
    * Otherwise, the existing <code>permissions</code> element will be returned.
    * @return  a new or existing instance of <code>PermissionsType<ModuleDescriptor></code> 
    */
   public PermissionsType<ModuleDescriptor> getOrCreatePermissions();

   /**
    * Removes the <code>permissions</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removePermissions();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeName();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor slot(String slot);

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
   public String getSlot();

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeSlot();
}
