package org.jboss.shrinkwrap.descriptor.api.jbossmodule15; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.PermissionType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.PermissionType;
/**
 * This interface defines the contract for the <code> permissionsType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PermissionsType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PermissionsType ElementName: jboss:permissionType ElementType : grant
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>grant</code> element will be created and returned.
    * Otherwise, the first existing <code>grant</code> element will be returned.
    * @return the instance defined for the element <code>grant</code> 
    */
   public PermissionType<PermissionsType<T>> getOrCreateGrant();

   /**
    * Creates a new <code>grant</code> element 
    * @return the new created instance of <code>PermissionType<PermissionsType<T>></code> 
    */
   public PermissionType<PermissionsType<T>> createGrant();

   /**
    * Returns all <code>grant</code> elements
    * @return list of <code>grant</code> 
    */
   public List<PermissionType<PermissionsType<T>>> getAllGrant();

   /**
    * Removes all <code>grant</code> elements 
    * @return the current instance of <code>PermissionType<PermissionsType<T>></code> 
    */
   public PermissionsType<T> removeAllGrant();
}
